/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.immutables.value.Value;

@FunctionalInterface
public interface TearDown<T> {
    public void onTearDown(T var1);

    @Value.Auxiliary
    default public TearDown<T> andThen(TearDown<T> next) {
        return t -> {
            RuntimeException first = null;
            RuntimeException second = null;
            try {
                this.onTearDown(t);
            }
            catch (RuntimeException ex) {
                first = ex;
            }
            try {
                next.onTearDown(t);
            }
            catch (RuntimeException ex) {
                second = ex;
            }
            if (first != null && second != null) {
                first.addSuppressed(second);
                throw first;
            }
            if (first != null || second != null) {
                throw first != null ? first : second;
            }
        };
    }

    @SafeVarargs
    public static <T> Optional<TearDown<T>> aggregate(TearDown<T> ... tearDowns) {
        return Stream.of(tearDowns).reduce(TearDown::andThen);
    }

    public static <T> TearDown<T> wrap(Consumer<T> wrap) {
        return wrap::accept;
    }
}

