package de.flapdoodle.reverse.graph;

import de.flapdoodle.reverse.StateID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StateVertex}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStateVertex.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStateVertex.of()}.
 */
@Generated(from = "StateVertex", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStateVertex extends StateVertex {
  private final StateID<?> stateId;

  private ImmutableStateVertex(StateID<?> stateId) {
    this.stateId = Objects.requireNonNull(stateId, "stateId");
  }

  private ImmutableStateVertex(ImmutableStateVertex original, StateID<?> stateId) {
    this.stateId = stateId;
  }

  /**
   * @return The value of the {@code stateId} attribute
   */
  @Override
  public StateID<?> stateId() {
    return stateId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StateVertex#stateId() stateId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stateId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStateVertex withStateId(StateID<?> value) {
    if (this.stateId == value) return this;
    StateID<?> newValue = Objects.requireNonNull(value, "stateId");
    return new ImmutableStateVertex(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStateVertex} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStateVertex
        && equalTo(0, (ImmutableStateVertex) another);
  }

  private boolean equalTo(int synthetic, ImmutableStateVertex another) {
    return stateId.equals(another.stateId);
  }

  /**
   * Computes a hash code from attributes: {@code stateId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + stateId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StateVertex} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StateVertex{"
        + "stateId=" + stateId
        + "}";
  }

  /**
   * Construct a new immutable {@code StateVertex} instance.
   * @param stateId The value for the {@code stateId} attribute
   * @return An immutable StateVertex instance
   */
  public static ImmutableStateVertex of(StateID<?> stateId) {
    return new ImmutableStateVertex(stateId);
  }

  /**
   * Creates an immutable copy of a {@link StateVertex} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StateVertex instance
   */
  public static ImmutableStateVertex copyOf(StateVertex instance) {
    if (instance instanceof ImmutableStateVertex) {
      return (ImmutableStateVertex) instance;
    }
    return ImmutableStateVertex.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStateVertex ImmutableStateVertex}.
   * <pre>
   * ImmutableStateVertex.builder()
   *    .stateId(de.flapdoodle.reverse.StateID&amp;lt;?&amp;gt;) // required {@link StateVertex#stateId() stateId}
   *    .build();
   * </pre>
   * @return A new ImmutableStateVertex builder
   */
  public static ImmutableStateVertex.Builder builder() {
    return new ImmutableStateVertex.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStateVertex ImmutableStateVertex}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StateVertex", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_STATE_ID = 0x1L;
    private long initBits = 0x1L;

    private StateID<?> stateId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StateVertex} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StateVertex instance) {
      Objects.requireNonNull(instance, "instance");
      this.stateId(instance.stateId());
      return this;
    }

    /**
     * Initializes the value for the {@link StateVertex#stateId() stateId} attribute.
     * @param stateId The value for stateId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stateId(StateID<?> stateId) {
      this.stateId = Objects.requireNonNull(stateId, "stateId");
      initBits &= ~INIT_BIT_STATE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStateVertex ImmutableStateVertex}.
     * @return An immutable instance of StateVertex
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStateVertex build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStateVertex(null, stateId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STATE_ID) != 0) attributes.add("stateId");
      return "Cannot build StateVertex, some of required attributes are not set " + attributes;
    }
  }
}
