package de.flapdoodle.reverse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Listener.StateListener}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStateListener.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStateListener.of()}.
 */
@Generated(from = "Listener.StateListener", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStateListener<T> implements Listener.StateListener<T> {
  private final StateID<T> type;
  private final Consumer<T> listener;

  private ImmutableStateListener(StateID<T> type, Consumer<T> listener) {
    this.type = Objects.requireNonNull(type, "type");
    this.listener = Objects.requireNonNull(listener, "listener");
  }

  private ImmutableStateListener(
      ImmutableStateListener<T> original,
      StateID<T> type,
      Consumer<T> listener) {
    this.type = type;
    this.listener = listener;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public StateID<T> type() {
    return type;
  }

  /**
   * @return The value of the {@code listener} attribute
   */
  @Override
  public Consumer<T> listener() {
    return listener;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Listener.StateListener#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStateListener<T> withType(StateID<T> value) {
    if (this.type == value) return this;
    StateID<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableStateListener<>(this, newValue, this.listener);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Listener.StateListener#listener() listener} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for listener
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStateListener<T> withListener(Consumer<T> value) {
    if (this.listener == value) return this;
    Consumer<T> newValue = Objects.requireNonNull(value, "listener");
    return new ImmutableStateListener<>(this, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStateListener} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStateListener<?>
        && equalTo(0, (ImmutableStateListener<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableStateListener<?> another) {
    return type.equals(another.type)
        && listener.equals(another.listener);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code listener}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + listener.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StateListener} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StateListener{"
        + "type=" + type
        + ", listener=" + listener
        + "}";
  }

  /**
   * Construct a new immutable {@code StateListener} instance.
 * @param <T> generic parameter T
   * @param type The value for the {@code type} attribute
   * @param listener The value for the {@code listener} attribute
   * @return An immutable StateListener instance
   */
  public static <T> ImmutableStateListener<T> of(StateID<T> type, Consumer<T> listener) {
    return new ImmutableStateListener<>(type, listener);
  }

  /**
   * Creates an immutable copy of a {@link Listener.StateListener} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable StateListener instance
   */
  public static <T> ImmutableStateListener<T> copyOf(Listener.StateListener<T> instance) {
    if (instance instanceof ImmutableStateListener<?>) {
      return (ImmutableStateListener<T>) instance;
    }
    return ImmutableStateListener.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStateListener ImmutableStateListener}.
   * <pre>
   * ImmutableStateListener.&amp;lt;T&amp;gt;builder()
   *    .type(de.flapdoodle.reverse.StateID&amp;lt;T&amp;gt;) // required {@link Listener.StateListener#type() type}
   *    .listener(function.Consumer&amp;lt;T&amp;gt;) // required {@link Listener.StateListener#listener() listener}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableStateListener builder
   */
  public static <T> ImmutableStateListener.Builder<T> builder() {
    return new ImmutableStateListener.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableStateListener ImmutableStateListener}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Listener.StateListener", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_LISTENER = 0x2L;
    private long initBits = 0x3L;

    private StateID<T> type;
    private Consumer<T> listener;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StateListener} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Listener.StateListener<T> instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.type());
      this.listener(instance.listener());
      return this;
    }

    /**
     * Initializes the value for the {@link Listener.StateListener#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(StateID<T> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Listener.StateListener#listener() listener} attribute.
     * @param listener The value for listener 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> listener(Consumer<T> listener) {
      this.listener = Objects.requireNonNull(listener, "listener");
      initBits &= ~INIT_BIT_LISTENER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStateListener ImmutableStateListener}.
     * @return An immutable instance of StateListener
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStateListener<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStateListener<>(null, type, listener);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_LISTENER) != 0) attributes.add("listener");
      return "Cannot build StateListener, some of required attributes are not set " + attributes;
    }
  }
}
