/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.reverse.ImmutableTransitionMapping;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateMapping;
import java.util.List;
import java.util.Optional;
import org.immutables.builder.Builder;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TransitionMapping<D> {
    @Builder.Parameter
    public abstract String label();

    @Builder.Parameter
    public abstract StateMapping<D> destination();

    public abstract List<StateMapping<?>> mappings();

    protected <T> Optional<StateID<T>> findDestinationOf(StateID<T> source) {
        return this.mappings().stream().filter(it -> it.source().equals(source)).map(it -> it).findFirst().map(StateMapping::destination);
    }

    protected <T> StateID<T> destinationOf(StateID<T> source) {
        return this.findDestinationOf(source).orElse(source);
    }

    protected <T> Optional<StateID<T>> findSourceOf(StateID<T> destination) {
        return this.mappings().stream().filter(it -> it.destination().equals(destination)).map(it -> it).findFirst().map(StateMapping::source);
    }

    protected <T> StateID<T> sourceOf(StateID<T> destination) {
        return this.findSourceOf(destination).orElse(destination);
    }

    public static <D> ImmutableTransitionMapping.Builder<D> builder(String label, StateID<D> destination) {
        return TransitionMapping.builder(label, StateMapping.of(destination, destination));
    }

    public static <D> ImmutableTransitionMapping.Builder<D> builder(String label, StateMapping<D> mapping) {
        return ImmutableTransitionMapping.builder(label, mapping);
    }
}

