/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.net;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.net.ProxyFactory;
import de.flapdoodle.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvProxySelector
implements ProxySelector {
    private static final Logger logger = LoggerFactory.getLogger((String)EnvProxySelector.class.getName());
    private final ProxySelector httpProxySelector;
    private final ProxySelector httpsProxySelector;

    private EnvProxySelector(ProxySelector httpProxySelector, ProxySelector httpsProxySelector) {
        logger.info("http proxy selector {}", (Object)httpProxySelector);
        logger.info("https proxy selector {}", (Object)httpsProxySelector);
        this.httpProxySelector = httpProxySelector;
        this.httpsProxySelector = httpsProxySelector;
    }

    @Override
    public Optional<ProxyFactory> select(URL url) {
        Preconditions.checkNotNull(url, "url is null", new Object[0]);
        String protocol = url.getProtocol();
        if (protocol.equals("http")) {
            return this.httpProxySelector.select(url);
        }
        if (protocol.equals("https")) {
            return this.httpsProxySelector.select(url);
        }
        return Optional.empty();
    }

    private static Optional<Pattern> noProxy(String noProxy) {
        return noProxy != null ? EnvProxySelector.toPattern(noProxy) : Optional.empty();
    }

    private static ProxySelector proxy(String proxyUrl, Optional<Pattern> noProxyPattern) {
        if (proxyUrl != null) {
            URI proxyUri = URI.create(proxyUrl);
            String proxyHostName = proxyUri.getHost();
            int proxyPort = proxyUri.getPort();
            Preconditions.checkArgument(proxyUri.getUserInfo() == null, "UserInfo not supported: %s", proxyUri.getUserInfo());
            return new HostnameBasesProxySelector(proxyHostName, proxyPort, noProxyPattern);
        }
        return ProxySelector.noProxy();
    }

    static Optional<Pattern> toPattern(String mask) {
        boolean disjunctionEmpty = true;
        StringJoiner joiner = new StringJoiner("|");
        for (String disjunct : mask.split(",")) {
            if (disjunct.isEmpty()) continue;
            disjunctionEmpty = false;
            String regex = EnvProxySelector.disjunctToRegex(disjunct.toLowerCase());
            joiner.add(regex);
        }
        return !disjunctionEmpty ? Optional.of(Pattern.compile(joiner.toString())) : Optional.empty();
    }

    static String disjunctToRegex(String disjunct) {
        String regex = disjunct.startsWith("*") && disjunct.endsWith("*") ? ".*" + Pattern.quote(disjunct.substring(1, disjunct.length() - 1)) + ".*" : (disjunct.startsWith("*") ? ".*" + Pattern.quote(disjunct.substring(1)) : (disjunct.endsWith("*") ? Pattern.quote(disjunct.substring(0, disjunct.length() - 1)) + ".*" : Pattern.quote(disjunct)));
        return regex;
    }

    public static ProxySelector with(Map<String, String> env) {
        String http_proxy = env.get("http_proxy");
        String https_proxy = env.get("https_proxy");
        String no_proxy = env.get("no_proxy");
        if (http_proxy != null || https_proxy != null) {
            Optional<Pattern> noProxyPattern = EnvProxySelector.noProxy(no_proxy);
            return new EnvProxySelector(EnvProxySelector.proxy(http_proxy, noProxyPattern), EnvProxySelector.proxy(https_proxy, noProxyPattern));
        }
        return ProxySelector.noProxy();
    }

    static class HostnameBasesProxySelector
    implements ProxySelector {
        private final String proxyHostName;
        private final int proxyPort;
        private final Optional<Pattern> noProxyPattern;

        private HostnameBasesProxySelector(String proxyHostName, int proxyPort, Optional<Pattern> noProxyPattern) {
            this.proxyHostName = proxyHostName;
            this.proxyPort = proxyPort;
            this.noProxyPattern = noProxyPattern;
        }

        public String toString() {
            return "HostnameBasesProxySelector{proxyHostName='" + this.proxyHostName + '\'' + ", proxyPort=" + this.proxyPort + ", noProxyPattern=" + this.noProxyPattern + '}';
        }

        @Override
        public Optional<ProxyFactory> select(URL url) {
            Preconditions.checkNotNull(url, "url is null", new Object[0]);
            if (this.useProxy(this.noProxyPattern, url)) {
                return Optional.of(ProxyFactory.of(this.proxyHostName, this.proxyPort));
            }
            return Optional.empty();
        }

        private boolean useProxy(Optional<Pattern> noProxyPattern, URL url) {
            if (noProxyPattern.isPresent()) {
                String auth;
                String host = url.getHost();
                if (host == null && (auth = url.getAuthority()) != null) {
                    int i = auth.indexOf(64);
                    if (i >= 0) {
                        auth = auth.substring(i + 1);
                    }
                    if ((i = auth.lastIndexOf(58)) >= 0) {
                        auth = auth.substring(0, i);
                    }
                    host = auth;
                }
                return host == null || !noProxyPattern.get().matcher(host.toLowerCase()).matches();
            }
            return true;
        }
    }
}

