package de.flapdoodle.reflection;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MapTypeInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMapTypeInfo.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMapTypeInfo.of()}.
 */
@Generated(from = "MapTypeInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMapTypeInfo<K, V> extends MapTypeInfo<K, V> {
  private final TypeInfo<K> key;
  private final TypeInfo<V> value;

  private ImmutableMapTypeInfo(TypeInfo<K> key, TypeInfo<V> value) {
    this.key = Objects.requireNonNull(key, "key");
    this.value = Objects.requireNonNull(value, "value");
  }

  private ImmutableMapTypeInfo(
      ImmutableMapTypeInfo<K, V> original,
      TypeInfo<K> key,
      TypeInfo<V> value) {
    this.key = key;
    this.value = value;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public TypeInfo<K> key() {
    return key;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public TypeInfo<V> value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MapTypeInfo#key() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapTypeInfo<K, V> withKey(TypeInfo<K> value) {
    if (this.key == value) return this;
    TypeInfo<K> newValue = Objects.requireNonNull(value, "key");
    return new ImmutableMapTypeInfo<>(this, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MapTypeInfo#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapTypeInfo<K, V> withValue(TypeInfo<V> value) {
    if (this.value == value) return this;
    TypeInfo<V> newValue = Objects.requireNonNull(value, "value");
    return new ImmutableMapTypeInfo<>(this, this.key, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMapTypeInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMapTypeInfo<?, ?>
        && equalTo(0, (ImmutableMapTypeInfo<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableMapTypeInfo<?, ?> another) {
    return key.equals(another.key)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MapTypeInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MapTypeInfo{"
        + "key=" + key
        + ", value=" + value
        + "}";
  }

  /**
   * Construct a new immutable {@code MapTypeInfo} instance.
 * @param <K> generic parameter K
 * @param <V> generic parameter V
   * @param key The value for the {@code key} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable MapTypeInfo instance
   */
  public static <K, V> ImmutableMapTypeInfo<K, V> of(TypeInfo<K> key, TypeInfo<V> value) {
    return new ImmutableMapTypeInfo<>(key, value);
  }

  /**
   * Creates an immutable copy of a {@link MapTypeInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <K> generic parameter K
   * @param <V> generic parameter V
   * @param instance The instance to copy
   * @return A copied immutable MapTypeInfo instance
   */
  public static <K, V> ImmutableMapTypeInfo<K, V> copyOf(MapTypeInfo<K, V> instance) {
    if (instance instanceof ImmutableMapTypeInfo<?, ?>) {
      return (ImmutableMapTypeInfo<K, V>) instance;
    }
    return ImmutableMapTypeInfo.<K, V>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMapTypeInfo ImmutableMapTypeInfo}.
   * <pre>
   * ImmutableMapTypeInfo.&amp;lt;K, V&amp;gt;builder()
   *    .key(de.flapdoodle.reflection.TypeInfo&amp;lt;K&amp;gt;) // required {@link MapTypeInfo#key() key}
   *    .value(de.flapdoodle.reflection.TypeInfo&amp;lt;V&amp;gt;) // required {@link MapTypeInfo#value() value}
   *    .build();
   * </pre>
   * @param <K> generic parameter K
   * @param <V> generic parameter V
   * @return A new ImmutableMapTypeInfo builder
   */
  public static <K, V> ImmutableMapTypeInfo.Builder<K, V> builder() {
    return new ImmutableMapTypeInfo.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableMapTypeInfo ImmutableMapTypeInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MapTypeInfo", generator = "Immutables")
  public static final class Builder<K, V> {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private TypeInfo<K> key;
    private TypeInfo<V> value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MapTypeInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<K, V> from(MapTypeInfo<K, V> instance) {
      Objects.requireNonNull(instance, "instance");
      this.key(instance.key());
      this.value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link MapTypeInfo#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<K, V> key(TypeInfo<K> key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link MapTypeInfo#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<K, V> value(TypeInfo<V> value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMapTypeInfo ImmutableMapTypeInfo}.
     * @return An immutable instance of MapTypeInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMapTypeInfo<K, V> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMapTypeInfo<>(null, key, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build MapTypeInfo, some of required attributes are not set " + attributes;
    }
  }
}
