package de.flapdoodle.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jgrapht.Graph;

/**
 * Immutable implementation of {@link GraphAsDot.SubGraph}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSubGraph.builder()}.
 */
@Generated(from = "GraphAsDot.SubGraph", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSubGraph<T> implements GraphAsDot.SubGraph<T> {
  private final Graph<T, ?> graph;
  private final Map<T, T> connections;

  private ImmutableSubGraph(Graph<T, ?> graph, Map<T, T> connections) {
    this.graph = graph;
    this.connections = connections;
  }

  /**
   * @return The value of the {@code graph} attribute
   */
  @Override
  public Graph<T, ?> graph() {
    return graph;
  }

  /**
   * @return The value of the {@code connections} attribute
   */
  @Override
  public Map<T, T> connections() {
    return connections;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot.SubGraph#graph() graph} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for graph
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSubGraph<T> withGraph(Graph<T, ?> value) {
    if (this.graph == value) return this;
    Graph<T, ?> newValue = Objects.requireNonNull(value, "graph");
    return new ImmutableSubGraph<>(newValue, this.connections);
  }

  /**
   * Copy the current immutable object by replacing the {@link GraphAsDot.SubGraph#connections() connections} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the connections map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSubGraph<T> withConnections(Map<? extends T, ? extends T> entries) {
    if (this.connections == entries) return this;
    Map<T, T> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableSubGraph<>(this.graph, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSubGraph} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSubGraph<?>
        && equalTo(0, (ImmutableSubGraph<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableSubGraph<?> another) {
    return graph.equals(another.graph)
        && connections.equals(another.connections);
  }

  /**
   * Computes a hash code from attributes: {@code graph}, {@code connections}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + graph.hashCode();
    h += (h << 5) + connections.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SubGraph} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SubGraph{"
        + "graph=" + graph
        + ", connections=" + connections
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link GraphAsDot.SubGraph} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable SubGraph instance
   */
  public static <T> ImmutableSubGraph<T> copyOf(GraphAsDot.SubGraph<T> instance) {
    if (instance instanceof ImmutableSubGraph<?>) {
      return (ImmutableSubGraph<T>) instance;
    }
    return ImmutableSubGraph.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSubGraph ImmutableSubGraph}.
   * <pre>
   * ImmutableSubGraph.&amp;lt;T&amp;gt;builder()
   *    .graph(org.jgrapht.Graph&amp;lt;T, ?&amp;gt;) // required {@link GraphAsDot.SubGraph#graph() graph}
   *    .putConnections|putAllConnections(T =&gt; T) // {@link GraphAsDot.SubGraph#connections() connections} mappings
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param graph {@code graph} parameter
   * @return A new ImmutableSubGraph builder
   */
  public static <T> ImmutableSubGraph.Builder<T> builder(Graph<T, ?> graph) {
    return new ImmutableSubGraph.Builder<>(graph);
  }

  static <T> ImmutableSubGraph.Builder<T> builder() {
    return new ImmutableSubGraph.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableSubGraph ImmutableSubGraph}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GraphAsDot.SubGraph", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_GRAPH = 0x1L;
    private long initBits = 0x1L;

    private Graph<T, ?> graph;
    private Map<T, T> connections = new LinkedHashMap<T, T>();

    private Builder(Graph<T, ?> graph) {
      graph(graph);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SubGraph} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(GraphAsDot.SubGraph<T> instance) {
      Objects.requireNonNull(instance, "instance");
      graph(instance.graph());
      putAllConnections(instance.connections());
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot.SubGraph#graph() graph} attribute.
     * @param graph The value for graph 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<T> graph(Graph<T, ?> graph) {
      this.graph = Objects.requireNonNull(graph, "graph");
      initBits &= ~INIT_BIT_GRAPH;
      return this;
    }

    /**
     * Put one entry to the {@link GraphAsDot.SubGraph#connections() connections} map.
     * @param key The key in the connections map
     * @param value The associated value in the connections map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> putConnections(T key, T value) {
      this.connections.put(
          Objects.requireNonNull(key, "connections key"),
          value == null ? Objects.requireNonNull(value, "connections value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link GraphAsDot.SubGraph#connections() connections} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> putConnections(Map.Entry<? extends T, ? extends T> entry) {
      T k = entry.getKey();
      T v = entry.getValue();
      this.connections.put(
          Objects.requireNonNull(k, "connections key"),
          v == null ? Objects.requireNonNull(v, "connections value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GraphAsDot.SubGraph#connections() connections} map. Nulls are not permitted
     * @param entries The entries that will be added to the connections map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> connections(Map<? extends T, ? extends T> entries) {
      this.connections.clear();
      return putAllConnections(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GraphAsDot.SubGraph#connections() connections} map. Nulls are not permitted
     * @param entries The entries that will be added to the connections map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> putAllConnections(Map<? extends T, ? extends T> entries) {
      for (Map.Entry<? extends T, ? extends T> e : entries.entrySet()) {
        T k = e.getKey();
        T v = e.getValue();
        this.connections.put(
            Objects.requireNonNull(k, "connections key"),
            v == null ? Objects.requireNonNull(v, "connections value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSubGraph ImmutableSubGraph}.
     * @return An immutable instance of SubGraph
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSubGraph<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSubGraph<>(graph, createUnmodifiableMap(false, false, connections));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GRAPH) != 0) attributes.add("graph");
      return "Cannot build SubGraph, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
