/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.transitions.ExtractPackage;
import de.flapdoodle.embed.process.types.Archive;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableExtractPackage
extends ExtractPackage {
    private final String transitionLabel;
    private final StateID<Name> name;
    private final StateID<ExtractedFileSet> destination;
    private final StateID<Archive> archive;
    private final StateID<Package> distPackage;
    private final StateID<TempDir> tempDir;
    private final StateID<ExtractedFileSetStore> extractedFileSetStore;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableExtractPackage(Builder builder) {
        this.extractedFileSetStore = builder.extractedFileSetStore;
        if (builder.transitionLabel != null) {
            this.initShim.transitionLabel(builder.transitionLabel);
        }
        if (builder.name != null) {
            this.initShim.name((StateID<Name>)builder.name);
        }
        if (builder.destination != null) {
            this.initShim.destination((StateID<ExtractedFileSet>)builder.destination);
        }
        if (builder.archive != null) {
            this.initShim.archive((StateID<Archive>)builder.archive);
        }
        if (builder.distPackage != null) {
            this.initShim.distPackage((StateID<Package>)builder.distPackage);
        }
        if (builder.tempDir != null) {
            this.initShim.tempDir((StateID<TempDir>)builder.tempDir);
        }
        this.transitionLabel = this.initShim.transitionLabel();
        this.name = this.initShim.name();
        this.destination = this.initShim.destination();
        this.archive = this.initShim.archive();
        this.distPackage = this.initShim.distPackage();
        this.tempDir = this.initShim.tempDir();
        this.initShim = null;
    }

    private ImmutableExtractPackage(String transitionLabel, StateID<Name> name, StateID<ExtractedFileSet> destination, StateID<Archive> archive, StateID<Package> distPackage, StateID<TempDir> tempDir, StateID<ExtractedFileSetStore> extractedFileSetStore) {
        this.transitionLabel = transitionLabel;
        this.name = name;
        this.destination = destination;
        this.archive = archive;
        this.distPackage = distPackage;
        this.tempDir = tempDir;
        this.extractedFileSetStore = extractedFileSetStore;
        this.initShim = null;
    }

    @Override
    public String transitionLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transitionLabel() : this.transitionLabel;
    }

    @Override
    protected StateID<Name> name() {
        InitShim shim = this.initShim;
        return shim != null ? shim.name() : this.name;
    }

    @Override
    public StateID<ExtractedFileSet> destination() {
        InitShim shim = this.initShim;
        return shim != null ? shim.destination() : this.destination;
    }

    @Override
    protected StateID<Archive> archive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.archive() : this.archive;
    }

    @Override
    protected StateID<Package> distPackage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.distPackage() : this.distPackage;
    }

    @Override
    protected StateID<TempDir> tempDir() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tempDir() : this.tempDir;
    }

    @Override
    protected Optional<StateID<ExtractedFileSetStore>> extractedFileSetStore() {
        return Optional.ofNullable(this.extractedFileSetStore);
    }

    public final ImmutableExtractPackage withTransitionLabel(String value) {
        String newValue = Objects.requireNonNull(value, "transitionLabel");
        if (this.transitionLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableExtractPackage(newValue, this.name, this.destination, this.archive, this.distPackage, this.tempDir, this.extractedFileSetStore);
    }

    public final ImmutableExtractPackage withName(StateID<Name> value) {
        if (this.name == value) {
            return this;
        }
        StateID<Name> newValue = Objects.requireNonNull(value, "name");
        return new ImmutableExtractPackage(this.transitionLabel, newValue, this.destination, this.archive, this.distPackage, this.tempDir, this.extractedFileSetStore);
    }

    public final ImmutableExtractPackage withDestination(StateID<ExtractedFileSet> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<ExtractedFileSet> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableExtractPackage(this.transitionLabel, this.name, newValue, this.archive, this.distPackage, this.tempDir, this.extractedFileSetStore);
    }

    public final ImmutableExtractPackage withArchive(StateID<Archive> value) {
        if (this.archive == value) {
            return this;
        }
        StateID<Archive> newValue = Objects.requireNonNull(value, "archive");
        return new ImmutableExtractPackage(this.transitionLabel, this.name, this.destination, newValue, this.distPackage, this.tempDir, this.extractedFileSetStore);
    }

    public final ImmutableExtractPackage withDistPackage(StateID<Package> value) {
        if (this.distPackage == value) {
            return this;
        }
        StateID<Package> newValue = Objects.requireNonNull(value, "distPackage");
        return new ImmutableExtractPackage(this.transitionLabel, this.name, this.destination, this.archive, newValue, this.tempDir, this.extractedFileSetStore);
    }

    public final ImmutableExtractPackage withTempDir(StateID<TempDir> value) {
        if (this.tempDir == value) {
            return this;
        }
        StateID<TempDir> newValue = Objects.requireNonNull(value, "tempDir");
        return new ImmutableExtractPackage(this.transitionLabel, this.name, this.destination, this.archive, this.distPackage, newValue, this.extractedFileSetStore);
    }

    public final ImmutableExtractPackage withExtractedFileSetStore(StateID<ExtractedFileSetStore> value) {
        StateID<ExtractedFileSetStore> newValue = Objects.requireNonNull(value, "extractedFileSetStore");
        if (this.extractedFileSetStore == newValue) {
            return this;
        }
        return new ImmutableExtractPackage(this.transitionLabel, this.name, this.destination, this.archive, this.distPackage, this.tempDir, newValue);
    }

    public final ImmutableExtractPackage withExtractedFileSetStore(Optional<? extends StateID<ExtractedFileSetStore>> optional) {
        StateID value = optional.orElse(null);
        if (this.extractedFileSetStore == value) {
            return this;
        }
        return new ImmutableExtractPackage(this.transitionLabel, this.name, this.destination, this.archive, this.distPackage, this.tempDir, (StateID<ExtractedFileSetStore>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtractPackage && this.equalsByValue((ImmutableExtractPackage)another);
    }

    private boolean equalsByValue(ImmutableExtractPackage another) {
        return this.transitionLabel.equals(another.transitionLabel) && this.name.equals(another.name) && this.destination.equals(another.destination) && this.archive.equals(another.archive) && this.distPackage.equals(another.distPackage) && this.tempDir.equals(another.tempDir) && Objects.equals(this.extractedFileSetStore, another.extractedFileSetStore);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transitionLabel.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.archive.hashCode();
        h += (h << 5) + this.distPackage.hashCode();
        h += (h << 5) + this.tempDir.hashCode();
        h += (h << 5) + Objects.hashCode(this.extractedFileSetStore);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ExtractPackage{");
        builder.append("transitionLabel=").append(this.transitionLabel);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("destination=").append(this.destination);
        builder.append(", ");
        builder.append("archive=").append(this.archive);
        builder.append(", ");
        builder.append("distPackage=").append(this.distPackage);
        builder.append(", ");
        builder.append("tempDir=").append(this.tempDir);
        if (this.extractedFileSetStore != null) {
            builder.append(", ");
            builder.append("extractedFileSetStore=").append(this.extractedFileSetStore);
        }
        return builder.append("}").toString();
    }

    public static ImmutableExtractPackage copyOf(ExtractPackage instance) {
        if (instance instanceof ImmutableExtractPackage) {
            return (ImmutableExtractPackage)instance;
        }
        return ImmutableExtractPackage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String transitionLabel;
        private StateID<Name> name;
        private StateID<ExtractedFileSet> destination;
        private StateID<Archive> archive;
        private StateID<Package> distPackage;
        private StateID<TempDir> tempDir;
        private StateID<ExtractedFileSetStore> extractedFileSetStore;

        private Builder() {
        }

        public final Builder from(ExtractPackage instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(HasLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ExtractPackage instance;
            long bits = 0L;
            if (object instanceof ExtractPackage) {
                instance = (ExtractPackage)object;
                Optional<StateID<ExtractedFileSetStore>> extractedFileSetStoreOptional = instance.extractedFileSetStore();
                if (extractedFileSetStoreOptional.isPresent()) {
                    this.extractedFileSetStore(extractedFileSetStoreOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
                this.destination(instance.destination());
                this.name(instance.name());
                this.distPackage(instance.distPackage());
                this.tempDir(instance.tempDir());
                this.archive(instance.archive());
            }
            if (object instanceof HasLabel) {
                instance = (HasLabel)object;
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
            }
        }

        public final Builder transitionLabel(String transitionLabel) {
            this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
            return this;
        }

        public final Builder name(StateID<Name> name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public final Builder destination(StateID<ExtractedFileSet> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        public final Builder archive(StateID<Archive> archive) {
            this.archive = Objects.requireNonNull(archive, "archive");
            return this;
        }

        public final Builder distPackage(StateID<Package> distPackage) {
            this.distPackage = Objects.requireNonNull(distPackage, "distPackage");
            return this;
        }

        public final Builder tempDir(StateID<TempDir> tempDir) {
            this.tempDir = Objects.requireNonNull(tempDir, "tempDir");
            return this;
        }

        public final Builder extractedFileSetStore(StateID<ExtractedFileSetStore> extractedFileSetStore) {
            this.extractedFileSetStore = Objects.requireNonNull(extractedFileSetStore, "extractedFileSetStore");
            return this;
        }

        public final Builder extractedFileSetStore(Optional<? extends StateID<ExtractedFileSetStore>> extractedFileSetStore) {
            this.extractedFileSetStore = extractedFileSetStore.orElse(null);
            return this;
        }

        public ImmutableExtractPackage build() {
            return new ImmutableExtractPackage(this);
        }
    }

    private final class InitShim {
        private byte transitionLabelBuildStage = 0;
        private String transitionLabel;
        private byte nameBuildStage = 0;
        private StateID<Name> name;
        private byte destinationBuildStage = 0;
        private StateID<ExtractedFileSet> destination;
        private byte archiveBuildStage = 0;
        private StateID<Archive> archive;
        private byte distPackageBuildStage = 0;
        private StateID<Package> distPackage;
        private byte tempDirBuildStage = 0;
        private StateID<TempDir> tempDir;

        private InitShim() {
        }

        String transitionLabel() {
            if (this.transitionLabelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transitionLabelBuildStage == 0) {
                this.transitionLabelBuildStage = (byte)-1;
                String computedValue = ImmutableExtractPackage.super.transitionLabel();
                this.transitionLabel = Objects.requireNonNull(computedValue, "transitionLabel");
                this.transitionLabelBuildStage = 1;
            }
            return this.transitionLabel;
        }

        void transitionLabel(String transitionLabel) {
            this.transitionLabel = transitionLabel;
            this.transitionLabelBuildStage = 1;
        }

        StateID<Name> name() {
            if (this.nameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameBuildStage == 0) {
                this.nameBuildStage = (byte)-1;
                StateID computedValue = ImmutableExtractPackage.super.name();
                this.name = Objects.requireNonNull(computedValue, "name");
                this.nameBuildStage = 1;
            }
            return this.name;
        }

        void name(StateID<Name> name) {
            this.name = name;
            this.nameBuildStage = 1;
        }

        StateID<ExtractedFileSet> destination() {
            if (this.destinationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.destinationBuildStage == 0) {
                this.destinationBuildStage = (byte)-1;
                StateID computedValue = ImmutableExtractPackage.super.destination();
                this.destination = Objects.requireNonNull(computedValue, "destination");
                this.destinationBuildStage = 1;
            }
            return this.destination;
        }

        void destination(StateID<ExtractedFileSet> destination) {
            this.destination = destination;
            this.destinationBuildStage = 1;
        }

        StateID<Archive> archive() {
            if (this.archiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.archiveBuildStage == 0) {
                this.archiveBuildStage = (byte)-1;
                StateID computedValue = ImmutableExtractPackage.super.archive();
                this.archive = Objects.requireNonNull(computedValue, "archive");
                this.archiveBuildStage = 1;
            }
            return this.archive;
        }

        void archive(StateID<Archive> archive) {
            this.archive = archive;
            this.archiveBuildStage = 1;
        }

        StateID<Package> distPackage() {
            if (this.distPackageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.distPackageBuildStage == 0) {
                this.distPackageBuildStage = (byte)-1;
                StateID computedValue = ImmutableExtractPackage.super.distPackage();
                this.distPackage = Objects.requireNonNull(computedValue, "distPackage");
                this.distPackageBuildStage = 1;
            }
            return this.distPackage;
        }

        void distPackage(StateID<Package> distPackage) {
            this.distPackage = distPackage;
            this.distPackageBuildStage = 1;
        }

        StateID<TempDir> tempDir() {
            if (this.tempDirBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tempDirBuildStage == 0) {
                this.tempDirBuildStage = (byte)-1;
                StateID computedValue = ImmutableExtractPackage.super.tempDir();
                this.tempDir = Objects.requireNonNull(computedValue, "tempDir");
                this.tempDirBuildStage = 1;
            }
            return this.tempDir;
        }

        void tempDir(StateID<TempDir> tempDir) {
            this.tempDir = tempDir;
            this.tempDirBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.transitionLabelBuildStage == -1) {
                attributes.add("transitionLabel");
            }
            if (this.nameBuildStage == -1) {
                attributes.add("name");
            }
            if (this.destinationBuildStage == -1) {
                attributes.add("destination");
            }
            if (this.archiveBuildStage == -1) {
                attributes.add("archive");
            }
            if (this.distPackageBuildStage == -1) {
                attributes.add("distPackage");
            }
            if (this.tempDirBuildStage == -1) {
                attributes.add("tempDir");
            }
            return "Cannot build ExtractPackage, attribute initializers form cycle " + attributes;
        }
    }
}

