package de.flapdoodle.embed.process.types;

import java.nio.file.Path;
import java.util.Objects;

/**
 * Immutable implementation of {@link _Archive}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code Archive.of()}.
 */
@SuppressWarnings({"all"})
public final class Archive extends de.flapdoodle.embed.process.types._Archive {
  private final Path value;

  private Archive(Path value) {
    this.value = Objects.requireNonNull(value, "value");
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Path value() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code Archive} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Archive
        && equalTo(0, (Archive) another);
  }

  private boolean equalTo(int synthetic, Archive another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code Archive} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable Archive instance
   */
  public static Archive of(Path value) {
    return new Archive(value);
  }
}
