/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.directories;

import de.flapdoodle.embed.process.io.directories.Directory;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserHome
implements Directory {
    private final String postFix;
    private static Logger logger = LoggerFactory.getLogger(UserHome.class);

    public UserHome(String postFix) {
        this.postFix = postFix;
    }

    @Override
    public File asFile() {
        return UserHome.userHome(System::getProperty).resolve(this.postFix).toFile();
    }

    @Override
    public boolean isGenerated() {
        return false;
    }

    public static Path userHome(Function<String, String> systemGetProperty) {
        Path path;
        String userHome = systemGetProperty.apply("user.home");
        if (userHome == null) {
            throw new IllegalArgumentException("user.home is null");
        }
        if ("?".equals(userHome)) {
            logger.warn("user.home is set to '?', maybe this is running inside a docker container");
            logger.warn("use fallback to user.dir");
            String userDir = systemGetProperty.apply("user.dir");
            if (userDir == null) {
                throw new IllegalArgumentException("user.dir is null");
            }
            if (userDir.equals("?")) {
                throw new IllegalArgumentException("user.dir is set to '?'");
            }
            logger.warn("use user.dir('{}') as fallback for user.home('{}')", (Object)userDir, (Object)userHome);
            userHome = userDir;
        }
        if (!Files.isDirectory(path = Paths.get(userHome, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("" + path + " is not a directory");
        }
        return path;
    }
}

