/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.process;

import de.flapdoodle.embed.process.config.process.ProcessConfig;
import de.flapdoodle.embed.process.io.StreamProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ProcessConfig", generator="Immutables")
public final class ImmutableProcessConfig
implements ProcessConfig {
    private final List<String> commandLine;
    private final StreamProcessor output;
    private final StreamProcessor error;

    private ImmutableProcessConfig(Builder builder) {
        this.commandLine = ImmutableProcessConfig.createUnmodifiableList(true, builder.commandLine);
        this.output = builder.output;
        this.error = builder.error != null ? builder.error : Objects.requireNonNull(ProcessConfig.super.error(), "error");
    }

    private ImmutableProcessConfig(List<String> commandLine, StreamProcessor output, StreamProcessor error) {
        this.commandLine = commandLine;
        this.output = output;
        this.error = error;
    }

    @Override
    public List<String> commandLine() {
        return this.commandLine;
    }

    @Override
    public StreamProcessor output() {
        return this.output;
    }

    @Override
    public StreamProcessor error() {
        return this.error;
    }

    public final ImmutableProcessConfig withCommandLine(String ... elements) {
        List<String> newValue = ImmutableProcessConfig.createUnmodifiableList(false, ImmutableProcessConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableProcessConfig(newValue, this.output, this.error);
    }

    public final ImmutableProcessConfig withCommandLine(Iterable<String> elements) {
        if (this.commandLine == elements) {
            return this;
        }
        List<String> newValue = ImmutableProcessConfig.createUnmodifiableList(false, ImmutableProcessConfig.createSafeList(elements, true, false));
        return new ImmutableProcessConfig(newValue, this.output, this.error);
    }

    public final ImmutableProcessConfig withOutput(StreamProcessor value) {
        if (this.output == value) {
            return this;
        }
        StreamProcessor newValue = Objects.requireNonNull(value, "output");
        return new ImmutableProcessConfig(this.commandLine, newValue, this.error);
    }

    public final ImmutableProcessConfig withError(StreamProcessor value) {
        if (this.error == value) {
            return this;
        }
        StreamProcessor newValue = Objects.requireNonNull(value, "error");
        return new ImmutableProcessConfig(this.commandLine, this.output, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessConfig && this.equalTo(0, (ImmutableProcessConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessConfig another) {
        return this.commandLine.equals(another.commandLine) && this.output.equals(another.output) && this.error.equals(another.error);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commandLine.hashCode();
        h += (h << 5) + this.output.hashCode();
        h += (h << 5) + this.error.hashCode();
        return h;
    }

    public String toString() {
        return "ProcessConfig{commandLine=" + this.commandLine + ", output=" + this.output + ", error=" + this.error + "}";
    }

    public static ImmutableProcessConfig copyOf(ProcessConfig instance) {
        if (instance instanceof ImmutableProcessConfig) {
            return (ImmutableProcessConfig)instance;
        }
        return ImmutableProcessConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ProcessConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_OUTPUT = 1L;
        private long initBits = 1L;
        private List<String> commandLine = new ArrayList<String>();
        private StreamProcessor output;
        private StreamProcessor error;

        private Builder() {
        }

        public final Builder from(ProcessConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCommandLine(instance.commandLine());
            this.output(instance.output());
            this.error(instance.error());
            return this;
        }

        public final Builder addCommandLine(String element) {
            this.commandLine.add(Objects.requireNonNull(element, "commandLine element"));
            return this;
        }

        public final Builder addCommandLine(String ... elements) {
            for (String element : elements) {
                this.commandLine.add(Objects.requireNonNull(element, "commandLine element"));
            }
            return this;
        }

        public final Builder commandLine(Iterable<String> elements) {
            this.commandLine.clear();
            return this.addAllCommandLine(elements);
        }

        public final Builder addAllCommandLine(Iterable<String> elements) {
            for (String element : elements) {
                this.commandLine.add(Objects.requireNonNull(element, "commandLine element"));
            }
            return this;
        }

        public final Builder output(StreamProcessor output) {
            this.output = Objects.requireNonNull(output, "output");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder error(StreamProcessor error) {
            this.error = Objects.requireNonNull(error, "error");
            return this;
        }

        public ImmutableProcessConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProcessConfig(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("output");
            }
            return "Cannot build ProcessConfig, some of required attributes are not set " + attributes;
        }
    }
}

