/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.io.Readers;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NUMA {
    private static Logger logger = LoggerFactory.getLogger(NUMA.class);
    private static final Map<Platform, Boolean> NUMA_STATUS_MAP = new HashMap<Platform, Boolean>();

    public static synchronized boolean isNUMA(SupportConfig support, Platform platform) {
        return NUMA_STATUS_MAP.computeIfAbsent(platform, p -> NUMA.isNUMAOnce(support, p));
    }

    public static boolean isNUMAOnce(SupportConfig support, Platform platform) {
        if (platform == Platform.Linux) {
            try {
                boolean isNUMA;
                ProcessControl process = ProcessControl.fromCommandLine(support, Arrays.asList("grep", "NUMA=y", "/boot/config-`uname -r`"), true);
                Reader reader = process.getReader();
                String content = Readers.readAll(reader);
                process.stop();
                boolean bl = isNUMA = !content.isEmpty();
                if (isNUMA) {
                    logger.warn("-----------------------------------------------\nNUMA support is still alpha. If you have any Problems with it, please contact us.\n-----------------------------------------------");
                }
                return isNUMA;
            }
            catch (IOException ix) {
                ix.printStackTrace();
            }
        }
        return false;
    }
}

