/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.io;

import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import java.util.logging.Level;
import org.slf4j.Logger;

public class ProcessOutput {
    protected final IStreamProcessor output;
    protected final IStreamProcessor error;
    protected final IStreamProcessor commands;

    public ProcessOutput(IStreamProcessor output, IStreamProcessor error, IStreamProcessor commands) {
        this.output = output;
        this.error = error;
        this.commands = commands;
    }

    public IStreamProcessor getOutput() {
        return this.output;
    }

    public IStreamProcessor getError() {
        return this.error;
    }

    public IStreamProcessor getCommands() {
        return this.commands;
    }

    public static ProcessOutput getDefaultInstance(String label) {
        return new ProcessOutput(Processors.namedConsole("[" + label + " output]"), Processors.namedConsole("[" + label + " error]"), Processors.console());
    }

    public static ProcessOutput getDefaultInstanceSilent() {
        return new ProcessOutput(Processors.silent(), Processors.silent(), Processors.silent());
    }

    public static ProcessOutput getInstance(String label, java.util.logging.Logger logger) {
        return new ProcessOutput(Processors.named("[" + label + " output]", Processors.logTo(logger, Level.INFO)), Processors.named("[" + label + " error]", Processors.logTo(logger, Level.SEVERE)), Processors.logTo(logger, Level.FINE));
    }

    public static ProcessOutput getInstance(String label, Logger logger) {
        return new ProcessOutput(Processors.named("[" + label + " output]", Processors.logTo(logger, Slf4jLevel.INFO)), Processors.named("[" + label + " error]", Processors.logTo(logger, Slf4jLevel.ERROR)), Processors.logTo(logger, Slf4jLevel.DEBUG));
    }
}

