/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.transitions.CommandName;
import de.flapdoodle.embed.mongo.transitions.Environment;
import de.flapdoodle.embed.mongo.transitions.ExtractFileSet;
import de.flapdoodle.embed.mongo.transitions.MongoRestore;
import de.flapdoodle.embed.mongo.transitions.ProcessDefaults;
import de.flapdoodle.embed.mongo.transitions.VersionAndPlatform;
import de.flapdoodle.embed.mongo.transitions.WorkspaceDefaults;
import de.flapdoodle.embed.mongo.types.DistributionBaseUrl;
import de.flapdoodle.embed.mongo.types.StartTimeout;
import de.flapdoodle.embed.mongo.types.SystemEnv;
import de.flapdoodle.embed.mongo.types.SystemProperties;
import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.io.directories.PersistentDir;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.transitions.DownloadPackage;
import de.flapdoodle.embed.process.transitions.InitTempDirectory;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.embed.process.types.ProcessWorkingDir;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.transitions.ImmutableStart;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableMongoRestore
extends MongoRestore {
    private final Transition<SystemEnv> systemEnv;
    private final Transition<SystemProperties> systemProperties;
    private final InitTempDirectory initTempDirectory;
    private final Transition<ProcessWorkingDir> processWorkingDir;
    private final Transition<Platform> platform;
    private final Transition<Distribution> distribution;
    private final Transition<DistributionBaseUrl> distributionBaseUrl;
    private final ImmutableStart<ProcessConfig> processConfig;
    private final Transition<ProcessEnv> processEnv;
    private final Transition<StartTimeout> startTimeout;
    private final Transition<ProcessOutput> processOutput;
    private final Transition<SupportConfig> supportConfig;
    private final Transition<Name> commandName;
    private final Transition<PersistentDir> persistentBaseDir;
    private final Transition<DownloadCache> downloadCache;
    private final Transition<ExtractedFileSetStore> extractedFileSetStore;
    private final DownloadPackage downloadPackage;
    private final Transition<ProgressListener> progressListener;
    private final Transition<ExtractedFileSet> extractPackage;
    private final Transition<Package> packageOfDistribution;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoRestore(Builder builder) {
        if (builder.systemEnv != null) {
            this.initShim.systemEnv((Transition<SystemEnv>)builder.systemEnv);
        }
        if (builder.systemProperties != null) {
            this.initShim.systemProperties((Transition<SystemProperties>)builder.systemProperties);
        }
        if (builder.initTempDirectory != null) {
            this.initShim.initTempDirectory(builder.initTempDirectory);
        }
        if (builder.processWorkingDir != null) {
            this.initShim.processWorkingDir((Transition<ProcessWorkingDir>)builder.processWorkingDir);
        }
        if (builder.platform != null) {
            this.initShim.platform((Transition<Platform>)builder.platform);
        }
        if (builder.distribution != null) {
            this.initShim.distribution((Transition<Distribution>)builder.distribution);
        }
        if (builder.distributionBaseUrl != null) {
            this.initShim.distributionBaseUrl((Transition<DistributionBaseUrl>)builder.distributionBaseUrl);
        }
        if (builder.processConfig != null) {
            this.initShim.processConfig((ImmutableStart<ProcessConfig>)builder.processConfig);
        }
        if (builder.processEnv != null) {
            this.initShim.processEnv((Transition<ProcessEnv>)builder.processEnv);
        }
        if (builder.startTimeout != null) {
            this.initShim.startTimeout((Transition<StartTimeout>)builder.startTimeout);
        }
        if (builder.processOutput != null) {
            this.initShim.processOutput((Transition<ProcessOutput>)builder.processOutput);
        }
        if (builder.supportConfig != null) {
            this.initShim.supportConfig((Transition<SupportConfig>)builder.supportConfig);
        }
        if (builder.commandName != null) {
            this.initShim.commandName((Transition<Name>)builder.commandName);
        }
        if (builder.persistentBaseDir != null) {
            this.initShim.persistentBaseDir((Transition<PersistentDir>)builder.persistentBaseDir);
        }
        if (builder.downloadCache != null) {
            this.initShim.downloadCache((Transition<DownloadCache>)builder.downloadCache);
        }
        if (builder.extractedFileSetStore != null) {
            this.initShim.extractedFileSetStore((Transition<ExtractedFileSetStore>)builder.extractedFileSetStore);
        }
        if (builder.downloadPackage != null) {
            this.initShim.downloadPackage(builder.downloadPackage);
        }
        if (builder.progressListener != null) {
            this.initShim.progressListener((Transition<ProgressListener>)builder.progressListener);
        }
        if (builder.extractPackage != null) {
            this.initShim.extractPackage((Transition<ExtractedFileSet>)builder.extractPackage);
        }
        if (builder.packageOfDistribution != null) {
            this.initShim.packageOfDistribution((Transition<Package>)builder.packageOfDistribution);
        }
        this.systemEnv = this.initShim.systemEnv();
        this.systemProperties = this.initShim.systemProperties();
        this.initTempDirectory = this.initShim.initTempDirectory();
        this.processWorkingDir = this.initShim.processWorkingDir();
        this.platform = this.initShim.platform();
        this.distribution = this.initShim.distribution();
        this.distributionBaseUrl = this.initShim.distributionBaseUrl();
        this.processConfig = this.initShim.processConfig();
        this.processEnv = this.initShim.processEnv();
        this.startTimeout = this.initShim.startTimeout();
        this.processOutput = this.initShim.processOutput();
        this.supportConfig = this.initShim.supportConfig();
        this.commandName = this.initShim.commandName();
        this.persistentBaseDir = this.initShim.persistentBaseDir();
        this.downloadCache = this.initShim.downloadCache();
        this.extractedFileSetStore = this.initShim.extractedFileSetStore();
        this.downloadPackage = this.initShim.downloadPackage();
        this.progressListener = this.initShim.progressListener();
        this.extractPackage = this.initShim.extractPackage();
        this.packageOfDistribution = this.initShim.packageOfDistribution();
        this.initShim = null;
    }

    private ImmutableMongoRestore(Transition<SystemEnv> systemEnv, Transition<SystemProperties> systemProperties, InitTempDirectory initTempDirectory, Transition<ProcessWorkingDir> processWorkingDir, Transition<Platform> platform, Transition<Distribution> distribution, Transition<DistributionBaseUrl> distributionBaseUrl, ImmutableStart<ProcessConfig> processConfig, Transition<ProcessEnv> processEnv, Transition<StartTimeout> startTimeout, Transition<ProcessOutput> processOutput, Transition<SupportConfig> supportConfig, Transition<Name> commandName, Transition<PersistentDir> persistentBaseDir, Transition<DownloadCache> downloadCache, Transition<ExtractedFileSetStore> extractedFileSetStore, DownloadPackage downloadPackage, Transition<ProgressListener> progressListener, Transition<ExtractedFileSet> extractPackage, Transition<Package> packageOfDistribution) {
        this.systemEnv = systemEnv;
        this.systemProperties = systemProperties;
        this.initTempDirectory = initTempDirectory;
        this.processWorkingDir = processWorkingDir;
        this.platform = platform;
        this.distribution = distribution;
        this.distributionBaseUrl = distributionBaseUrl;
        this.processConfig = processConfig;
        this.processEnv = processEnv;
        this.startTimeout = startTimeout;
        this.processOutput = processOutput;
        this.supportConfig = supportConfig;
        this.commandName = commandName;
        this.persistentBaseDir = persistentBaseDir;
        this.downloadCache = downloadCache;
        this.extractedFileSetStore = extractedFileSetStore;
        this.downloadPackage = downloadPackage;
        this.progressListener = progressListener;
        this.extractPackage = extractPackage;
        this.packageOfDistribution = packageOfDistribution;
        this.initShim = null;
    }

    @Override
    public Transition<SystemEnv> systemEnv() {
        InitShim shim = this.initShim;
        return shim != null ? shim.systemEnv() : this.systemEnv;
    }

    @Override
    public Transition<SystemProperties> systemProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.systemProperties() : this.systemProperties;
    }

    @Override
    public InitTempDirectory initTempDirectory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initTempDirectory() : this.initTempDirectory;
    }

    @Override
    public Transition<ProcessWorkingDir> processWorkingDir() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processWorkingDir() : this.processWorkingDir;
    }

    @Override
    public Transition<Platform> platform() {
        InitShim shim = this.initShim;
        return shim != null ? shim.platform() : this.platform;
    }

    @Override
    public Transition<Distribution> distribution() {
        InitShim shim = this.initShim;
        return shim != null ? shim.distribution() : this.distribution;
    }

    @Override
    public Transition<DistributionBaseUrl> distributionBaseUrl() {
        InitShim shim = this.initShim;
        return shim != null ? shim.distributionBaseUrl() : this.distributionBaseUrl;
    }

    @Override
    public ImmutableStart<ProcessConfig> processConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processConfig() : this.processConfig;
    }

    @Override
    public Transition<ProcessEnv> processEnv() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processEnv() : this.processEnv;
    }

    @Override
    public Transition<StartTimeout> startTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.startTimeout() : this.startTimeout;
    }

    @Override
    public Transition<ProcessOutput> processOutput() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processOutput() : this.processOutput;
    }

    @Override
    public Transition<SupportConfig> supportConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportConfig() : this.supportConfig;
    }

    @Override
    public Transition<Name> commandName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.commandName() : this.commandName;
    }

    @Override
    public Transition<PersistentDir> persistentBaseDir() {
        InitShim shim = this.initShim;
        return shim != null ? shim.persistentBaseDir() : this.persistentBaseDir;
    }

    @Override
    public Transition<DownloadCache> downloadCache() {
        InitShim shim = this.initShim;
        return shim != null ? shim.downloadCache() : this.downloadCache;
    }

    @Override
    public Transition<ExtractedFileSetStore> extractedFileSetStore() {
        InitShim shim = this.initShim;
        return shim != null ? shim.extractedFileSetStore() : this.extractedFileSetStore;
    }

    @Override
    public DownloadPackage downloadPackage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.downloadPackage() : this.downloadPackage;
    }

    @Override
    public Transition<ProgressListener> progressListener() {
        InitShim shim = this.initShim;
        return shim != null ? shim.progressListener() : this.progressListener;
    }

    @Override
    public Transition<ExtractedFileSet> extractPackage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.extractPackage() : this.extractPackage;
    }

    @Override
    public Transition<Package> packageOfDistribution() {
        InitShim shim = this.initShim;
        return shim != null ? shim.packageOfDistribution() : this.packageOfDistribution;
    }

    public final ImmutableMongoRestore withSystemEnv(Transition<SystemEnv> value) {
        if (this.systemEnv == value) {
            return this;
        }
        Transition<SystemEnv> newValue = Objects.requireNonNull(value, "systemEnv");
        return new ImmutableMongoRestore(newValue, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withSystemProperties(Transition<SystemProperties> value) {
        if (this.systemProperties == value) {
            return this;
        }
        Transition<SystemProperties> newValue = Objects.requireNonNull(value, "systemProperties");
        return new ImmutableMongoRestore(this.systemEnv, newValue, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withInitTempDirectory(InitTempDirectory value) {
        if (this.initTempDirectory == value) {
            return this;
        }
        InitTempDirectory newValue = Objects.requireNonNull(value, "initTempDirectory");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, newValue, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withProcessWorkingDir(Transition<ProcessWorkingDir> value) {
        if (this.processWorkingDir == value) {
            return this;
        }
        Transition<ProcessWorkingDir> newValue = Objects.requireNonNull(value, "processWorkingDir");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, newValue, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withPlatform(Transition<Platform> value) {
        if (this.platform == value) {
            return this;
        }
        Transition<Platform> newValue = Objects.requireNonNull(value, "platform");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, newValue, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withDistribution(Transition<Distribution> value) {
        if (this.distribution == value) {
            return this;
        }
        Transition<Distribution> newValue = Objects.requireNonNull(value, "distribution");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, newValue, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withDistributionBaseUrl(Transition<DistributionBaseUrl> value) {
        if (this.distributionBaseUrl == value) {
            return this;
        }
        Transition<DistributionBaseUrl> newValue = Objects.requireNonNull(value, "distributionBaseUrl");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, newValue, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withProcessConfig(ImmutableStart<ProcessConfig> value) {
        if (this.processConfig == value) {
            return this;
        }
        ImmutableStart<ProcessConfig> newValue = Objects.requireNonNull(value, "processConfig");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, newValue, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withProcessEnv(Transition<ProcessEnv> value) {
        if (this.processEnv == value) {
            return this;
        }
        Transition<ProcessEnv> newValue = Objects.requireNonNull(value, "processEnv");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, newValue, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withStartTimeout(Transition<StartTimeout> value) {
        if (this.startTimeout == value) {
            return this;
        }
        Transition<StartTimeout> newValue = Objects.requireNonNull(value, "startTimeout");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, newValue, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withProcessOutput(Transition<ProcessOutput> value) {
        if (this.processOutput == value) {
            return this;
        }
        Transition<ProcessOutput> newValue = Objects.requireNonNull(value, "processOutput");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, newValue, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withSupportConfig(Transition<SupportConfig> value) {
        if (this.supportConfig == value) {
            return this;
        }
        Transition<SupportConfig> newValue = Objects.requireNonNull(value, "supportConfig");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, newValue, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withCommandName(Transition<Name> value) {
        if (this.commandName == value) {
            return this;
        }
        Transition<Name> newValue = Objects.requireNonNull(value, "commandName");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, newValue, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withPersistentBaseDir(Transition<PersistentDir> value) {
        if (this.persistentBaseDir == value) {
            return this;
        }
        Transition<PersistentDir> newValue = Objects.requireNonNull(value, "persistentBaseDir");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, newValue, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withDownloadCache(Transition<DownloadCache> value) {
        if (this.downloadCache == value) {
            return this;
        }
        Transition<DownloadCache> newValue = Objects.requireNonNull(value, "downloadCache");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, newValue, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withExtractedFileSetStore(Transition<ExtractedFileSetStore> value) {
        if (this.extractedFileSetStore == value) {
            return this;
        }
        Transition<ExtractedFileSetStore> newValue = Objects.requireNonNull(value, "extractedFileSetStore");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, newValue, this.downloadPackage, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withDownloadPackage(DownloadPackage value) {
        if (this.downloadPackage == value) {
            return this;
        }
        DownloadPackage newValue = Objects.requireNonNull(value, "downloadPackage");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, newValue, this.progressListener, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withProgressListener(Transition<ProgressListener> value) {
        if (this.progressListener == value) {
            return this;
        }
        Transition<ProgressListener> newValue = Objects.requireNonNull(value, "progressListener");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, newValue, this.extractPackage, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withExtractPackage(Transition<ExtractedFileSet> value) {
        if (this.extractPackage == value) {
            return this;
        }
        Transition<ExtractedFileSet> newValue = Objects.requireNonNull(value, "extractPackage");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, newValue, this.packageOfDistribution);
    }

    public final ImmutableMongoRestore withPackageOfDistribution(Transition<Package> value) {
        if (this.packageOfDistribution == value) {
            return this;
        }
        Transition<Package> newValue = Objects.requireNonNull(value, "packageOfDistribution");
        return new ImmutableMongoRestore(this.systemEnv, this.systemProperties, this.initTempDirectory, this.processWorkingDir, this.platform, this.distribution, this.distributionBaseUrl, this.processConfig, this.processEnv, this.startTimeout, this.processOutput, this.supportConfig, this.commandName, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.downloadPackage, this.progressListener, this.extractPackage, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoRestore && this.equalsByValue((ImmutableMongoRestore)another);
    }

    private boolean equalsByValue(ImmutableMongoRestore another) {
        return this.systemEnv.equals(another.systemEnv) && this.systemProperties.equals(another.systemProperties) && this.initTempDirectory.equals(another.initTempDirectory) && this.processWorkingDir.equals(another.processWorkingDir) && this.platform.equals(another.platform) && this.distribution.equals(another.distribution) && this.distributionBaseUrl.equals(another.distributionBaseUrl) && this.processConfig.equals(another.processConfig) && this.processEnv.equals(another.processEnv) && this.startTimeout.equals(another.startTimeout) && this.processOutput.equals(another.processOutput) && this.supportConfig.equals(another.supportConfig) && this.commandName.equals(another.commandName) && this.persistentBaseDir.equals(another.persistentBaseDir) && this.downloadCache.equals(another.downloadCache) && this.extractedFileSetStore.equals(another.extractedFileSetStore) && this.downloadPackage.equals(another.downloadPackage) && this.progressListener.equals(another.progressListener) && this.extractPackage.equals(another.extractPackage) && this.packageOfDistribution.equals(another.packageOfDistribution);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.systemEnv.hashCode();
        h += (h << 5) + this.systemProperties.hashCode();
        h += (h << 5) + this.initTempDirectory.hashCode();
        h += (h << 5) + this.processWorkingDir.hashCode();
        h += (h << 5) + this.platform.hashCode();
        h += (h << 5) + this.distribution.hashCode();
        h += (h << 5) + this.distributionBaseUrl.hashCode();
        h += (h << 5) + this.processConfig.hashCode();
        h += (h << 5) + this.processEnv.hashCode();
        h += (h << 5) + this.startTimeout.hashCode();
        h += (h << 5) + this.processOutput.hashCode();
        h += (h << 5) + this.supportConfig.hashCode();
        h += (h << 5) + this.commandName.hashCode();
        h += (h << 5) + this.persistentBaseDir.hashCode();
        h += (h << 5) + this.downloadCache.hashCode();
        h += (h << 5) + this.extractedFileSetStore.hashCode();
        h += (h << 5) + this.downloadPackage.hashCode();
        h += (h << 5) + this.progressListener.hashCode();
        h += (h << 5) + this.extractPackage.hashCode();
        h += (h << 5) + this.packageOfDistribution.hashCode();
        return h;
    }

    public String toString() {
        return "MongoRestore{systemEnv=" + this.systemEnv + ", systemProperties=" + this.systemProperties + ", initTempDirectory=" + this.initTempDirectory + ", processWorkingDir=" + this.processWorkingDir + ", platform=" + this.platform + ", distribution=" + this.distribution + ", distributionBaseUrl=" + this.distributionBaseUrl + ", processConfig=" + this.processConfig + ", processEnv=" + this.processEnv + ", startTimeout=" + this.startTimeout + ", processOutput=" + this.processOutput + ", supportConfig=" + this.supportConfig + ", commandName=" + this.commandName + ", persistentBaseDir=" + this.persistentBaseDir + ", downloadCache=" + this.downloadCache + ", extractedFileSetStore=" + this.extractedFileSetStore + ", downloadPackage=" + this.downloadPackage + ", progressListener=" + this.progressListener + ", extractPackage=" + this.extractPackage + ", packageOfDistribution=" + this.packageOfDistribution + "}";
    }

    public static ImmutableMongoRestore copyOf(MongoRestore instance) {
        if (instance instanceof ImmutableMongoRestore) {
            return (ImmutableMongoRestore)instance;
        }
        return ImmutableMongoRestore.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Transition<SystemEnv> systemEnv;
        private Transition<SystemProperties> systemProperties;
        private InitTempDirectory initTempDirectory;
        private Transition<ProcessWorkingDir> processWorkingDir;
        private Transition<Platform> platform;
        private Transition<Distribution> distribution;
        private Transition<DistributionBaseUrl> distributionBaseUrl;
        private ImmutableStart<ProcessConfig> processConfig;
        private Transition<ProcessEnv> processEnv;
        private Transition<StartTimeout> startTimeout;
        private Transition<ProcessOutput> processOutput;
        private Transition<SupportConfig> supportConfig;
        private Transition<Name> commandName;
        private Transition<PersistentDir> persistentBaseDir;
        private Transition<DownloadCache> downloadCache;
        private Transition<ExtractedFileSetStore> extractedFileSetStore;
        private DownloadPackage downloadPackage;
        private Transition<ProgressListener> progressListener;
        private Transition<ExtractedFileSet> extractPackage;
        private Transition<Package> packageOfDistribution;

        private Builder() {
        }

        public final Builder from(MongoRestore instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(ExtractFileSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Environment instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(CommandName instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(ProcessDefaults instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(WorkspaceDefaults instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(VersionAndPlatform instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            long bits = 0L;
            if (object instanceof MongoRestore) {
                bits = this.mergeInternal(bits, (MongoRestore)object);
            }
            if (object instanceof ExtractFileSet) {
                bits = this.mergeInternal(bits, (ExtractFileSet)object);
            }
            if (object instanceof Environment) {
                bits = this.mergeInternal(bits, (Environment)object);
            }
            if (object instanceof CommandName) {
                bits = this.mergeInternal(bits, (CommandName)object);
            }
            if (object instanceof ProcessDefaults) {
                bits = this.mergeInternal(bits, (ProcessDefaults)object);
            }
            if (object instanceof WorkspaceDefaults) {
                bits = this.mergeInternal(bits, (WorkspaceDefaults)object);
            }
            if (object instanceof VersionAndPlatform) {
                bits = this.mergeInternal(bits, (VersionAndPlatform)object);
            }
        }

        private long mergeInternal(long bits, MongoRestore instance) {
            if ((bits & 1L) == 0L) {
                this.processConfig(instance.processConfig());
                bits |= 1L;
            }
            if ((bits & 2L) == 0L) {
                this.downloadCache(instance.downloadCache());
                bits |= 2L;
            }
            if ((bits & 4L) == 0L) {
                this.persistentBaseDir(instance.persistentBaseDir());
                bits |= 4L;
            }
            if ((bits & 8L) == 0L) {
                this.distribution(instance.distribution());
                bits |= 8L;
            }
            if ((bits & 0x10L) == 0L) {
                this.platform(instance.platform());
                bits |= 0x10L;
            }
            if ((bits & 0x20L) == 0L) {
                this.downloadPackage(instance.downloadPackage());
                bits |= 0x20L;
            }
            if ((bits & 0x40L) == 0L) {
                this.systemProperties(instance.systemProperties());
                bits |= 0x40L;
            }
            if ((bits & 0x80L) == 0L) {
                this.progressListener(instance.progressListener());
                bits |= 0x80L;
            }
            if ((bits & 0x100L) == 0L) {
                this.systemEnv(instance.systemEnv());
                bits |= 0x100L;
            }
            if ((bits & 0x200L) == 0L) {
                this.commandName(instance.commandName());
                bits |= 0x200L;
            }
            if ((bits & 0x400L) == 0L) {
                this.packageOfDistribution(instance.packageOfDistribution());
                bits |= 0x400L;
            }
            if ((bits & 0x800L) == 0L) {
                this.startTimeout(instance.startTimeout());
                bits |= 0x800L;
            }
            if ((bits & 0x1000L) == 0L) {
                this.supportConfig(instance.supportConfig());
                bits |= 0x1000L;
            }
            if ((bits & 0x2000L) == 0L) {
                this.extractedFileSetStore(instance.extractedFileSetStore());
                bits |= 0x2000L;
            }
            if ((bits & 0x4000L) == 0L) {
                this.initTempDirectory(instance.initTempDirectory());
                bits |= 0x4000L;
            }
            if ((bits & 0x8000L) == 0L) {
                this.extractPackage(instance.extractPackage());
                bits |= 0x8000L;
            }
            if ((bits & 0x10000L) == 0L) {
                this.processEnv(instance.processEnv());
                bits |= 0x10000L;
            }
            if ((bits & 0x20000L) == 0L) {
                this.processOutput(instance.processOutput());
                bits |= 0x20000L;
            }
            if ((bits & 0x40000L) == 0L) {
                this.processWorkingDir(instance.processWorkingDir());
                bits |= 0x40000L;
            }
            if ((bits & 0x80000L) == 0L) {
                this.distributionBaseUrl(instance.distributionBaseUrl());
                bits |= 0x80000L;
            }
            return bits;
        }

        private long mergeInternal(long bits, ExtractFileSet instance) {
            if ((bits & 0x80L) == 0L) {
                this.progressListener(instance.progressListener());
                bits |= 0x80L;
            }
            if ((bits & 0x400L) == 0L) {
                this.packageOfDistribution(instance.packageOfDistribution());
                bits |= 0x400L;
            }
            if ((bits & 0x2000L) == 0L) {
                this.extractedFileSetStore(instance.extractedFileSetStore());
                bits |= 0x2000L;
            }
            if ((bits & 0x8000L) == 0L) {
                this.extractPackage(instance.extractPackage());
                bits |= 0x8000L;
            }
            if ((bits & 2L) == 0L) {
                this.downloadCache(instance.downloadCache());
                bits |= 2L;
            }
            if ((bits & 4L) == 0L) {
                this.persistentBaseDir(instance.persistentBaseDir());
                bits |= 4L;
            }
            if ((bits & 0x20L) == 0L) {
                this.downloadPackage(instance.downloadPackage());
                bits |= 0x20L;
            }
            return bits;
        }

        private long mergeInternal(long bits, Environment instance) {
            if ((bits & 0x40L) == 0L) {
                this.systemProperties(instance.systemProperties());
                bits |= 0x40L;
            }
            if ((bits & 0x100L) == 0L) {
                this.systemEnv(instance.systemEnv());
                bits |= 0x100L;
            }
            return bits;
        }

        private long mergeInternal(long bits, CommandName instance) {
            if ((bits & 0x200L) == 0L) {
                this.commandName(instance.commandName());
                bits |= 0x200L;
            }
            return bits;
        }

        private long mergeInternal(long bits, ProcessDefaults instance) {
            if ((bits & 0x20000L) == 0L) {
                this.processOutput(instance.processOutput());
                bits |= 0x20000L;
            }
            if ((bits & 0x800L) == 0L) {
                this.startTimeout(instance.startTimeout());
                bits |= 0x800L;
            }
            if ((bits & 0x1000L) == 0L) {
                this.supportConfig(instance.supportConfig());
                bits |= 0x1000L;
            }
            if ((bits & 1L) == 0L) {
                this.processConfig(instance.processConfig());
                bits |= 1L;
            }
            if ((bits & 0x10000L) == 0L) {
                this.processEnv(instance.processEnv());
                bits |= 0x10000L;
            }
            return bits;
        }

        private long mergeInternal(long bits, WorkspaceDefaults instance) {
            if ((bits & 0x40000L) == 0L) {
                this.processWorkingDir(instance.processWorkingDir());
                bits |= 0x40000L;
            }
            if ((bits & 0x4000L) == 0L) {
                this.initTempDirectory(instance.initTempDirectory());
                bits |= 0x4000L;
            }
            return bits;
        }

        private long mergeInternal(long bits, VersionAndPlatform instance) {
            if ((bits & 8L) == 0L) {
                this.distribution(instance.distribution());
                bits |= 8L;
            }
            if ((bits & 0x10L) == 0L) {
                this.platform(instance.platform());
                bits |= 0x10L;
            }
            if ((bits & 0x80000L) == 0L) {
                this.distributionBaseUrl(instance.distributionBaseUrl());
                bits |= 0x80000L;
            }
            return bits;
        }

        public final Builder systemEnv(Transition<SystemEnv> systemEnv) {
            this.systemEnv = Objects.requireNonNull(systemEnv, "systemEnv");
            return this;
        }

        public final Builder systemProperties(Transition<SystemProperties> systemProperties) {
            this.systemProperties = Objects.requireNonNull(systemProperties, "systemProperties");
            return this;
        }

        public final Builder initTempDirectory(InitTempDirectory initTempDirectory) {
            this.initTempDirectory = Objects.requireNonNull(initTempDirectory, "initTempDirectory");
            return this;
        }

        public final Builder processWorkingDir(Transition<ProcessWorkingDir> processWorkingDir) {
            this.processWorkingDir = Objects.requireNonNull(processWorkingDir, "processWorkingDir");
            return this;
        }

        public final Builder platform(Transition<Platform> platform) {
            this.platform = Objects.requireNonNull(platform, "platform");
            return this;
        }

        public final Builder distribution(Transition<Distribution> distribution) {
            this.distribution = Objects.requireNonNull(distribution, "distribution");
            return this;
        }

        public final Builder distributionBaseUrl(Transition<DistributionBaseUrl> distributionBaseUrl) {
            this.distributionBaseUrl = Objects.requireNonNull(distributionBaseUrl, "distributionBaseUrl");
            return this;
        }

        public final Builder processConfig(ImmutableStart<ProcessConfig> processConfig) {
            this.processConfig = Objects.requireNonNull(processConfig, "processConfig");
            return this;
        }

        public final Builder processEnv(Transition<ProcessEnv> processEnv) {
            this.processEnv = Objects.requireNonNull(processEnv, "processEnv");
            return this;
        }

        public final Builder startTimeout(Transition<StartTimeout> startTimeout) {
            this.startTimeout = Objects.requireNonNull(startTimeout, "startTimeout");
            return this;
        }

        public final Builder processOutput(Transition<ProcessOutput> processOutput) {
            this.processOutput = Objects.requireNonNull(processOutput, "processOutput");
            return this;
        }

        public final Builder supportConfig(Transition<SupportConfig> supportConfig) {
            this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
            return this;
        }

        public final Builder commandName(Transition<Name> commandName) {
            this.commandName = Objects.requireNonNull(commandName, "commandName");
            return this;
        }

        public final Builder persistentBaseDir(Transition<PersistentDir> persistentBaseDir) {
            this.persistentBaseDir = Objects.requireNonNull(persistentBaseDir, "persistentBaseDir");
            return this;
        }

        public final Builder downloadCache(Transition<DownloadCache> downloadCache) {
            this.downloadCache = Objects.requireNonNull(downloadCache, "downloadCache");
            return this;
        }

        public final Builder extractedFileSetStore(Transition<ExtractedFileSetStore> extractedFileSetStore) {
            this.extractedFileSetStore = Objects.requireNonNull(extractedFileSetStore, "extractedFileSetStore");
            return this;
        }

        public final Builder downloadPackage(DownloadPackage downloadPackage) {
            this.downloadPackage = Objects.requireNonNull(downloadPackage, "downloadPackage");
            return this;
        }

        public final Builder progressListener(Transition<ProgressListener> progressListener) {
            this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
            return this;
        }

        public final Builder extractPackage(Transition<ExtractedFileSet> extractPackage) {
            this.extractPackage = Objects.requireNonNull(extractPackage, "extractPackage");
            return this;
        }

        public final Builder packageOfDistribution(Transition<Package> packageOfDistribution) {
            this.packageOfDistribution = Objects.requireNonNull(packageOfDistribution, "packageOfDistribution");
            return this;
        }

        public ImmutableMongoRestore build() {
            return new ImmutableMongoRestore(this);
        }
    }

    private final class InitShim {
        private byte systemEnvBuildStage = 0;
        private Transition<SystemEnv> systemEnv;
        private byte systemPropertiesBuildStage = 0;
        private Transition<SystemProperties> systemProperties;
        private byte initTempDirectoryBuildStage = 0;
        private InitTempDirectory initTempDirectory;
        private byte processWorkingDirBuildStage = 0;
        private Transition<ProcessWorkingDir> processWorkingDir;
        private byte platformBuildStage = 0;
        private Transition<Platform> platform;
        private byte distributionBuildStage = 0;
        private Transition<Distribution> distribution;
        private byte distributionBaseUrlBuildStage = 0;
        private Transition<DistributionBaseUrl> distributionBaseUrl;
        private byte processConfigBuildStage = 0;
        private ImmutableStart<ProcessConfig> processConfig;
        private byte processEnvBuildStage = 0;
        private Transition<ProcessEnv> processEnv;
        private byte startTimeoutBuildStage = 0;
        private Transition<StartTimeout> startTimeout;
        private byte processOutputBuildStage = 0;
        private Transition<ProcessOutput> processOutput;
        private byte supportConfigBuildStage = 0;
        private Transition<SupportConfig> supportConfig;
        private byte commandNameBuildStage = 0;
        private Transition<Name> commandName;
        private byte persistentBaseDirBuildStage = 0;
        private Transition<PersistentDir> persistentBaseDir;
        private byte downloadCacheBuildStage = 0;
        private Transition<DownloadCache> downloadCache;
        private byte extractedFileSetStoreBuildStage = 0;
        private Transition<ExtractedFileSetStore> extractedFileSetStore;
        private byte downloadPackageBuildStage = 0;
        private DownloadPackage downloadPackage;
        private byte progressListenerBuildStage = 0;
        private Transition<ProgressListener> progressListener;
        private byte extractPackageBuildStage = 0;
        private Transition<ExtractedFileSet> extractPackage;
        private byte packageOfDistributionBuildStage = 0;
        private Transition<Package> packageOfDistribution;

        private InitShim() {
        }

        Transition<SystemEnv> systemEnv() {
            if (this.systemEnvBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.systemEnvBuildStage == 0) {
                this.systemEnvBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.systemEnv();
                this.systemEnv = Objects.requireNonNull(computedValue, "systemEnv");
                this.systemEnvBuildStage = 1;
            }
            return this.systemEnv;
        }

        void systemEnv(Transition<SystemEnv> systemEnv) {
            this.systemEnv = systemEnv;
            this.systemEnvBuildStage = 1;
        }

        Transition<SystemProperties> systemProperties() {
            if (this.systemPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.systemPropertiesBuildStage == 0) {
                this.systemPropertiesBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.systemProperties();
                this.systemProperties = Objects.requireNonNull(computedValue, "systemProperties");
                this.systemPropertiesBuildStage = 1;
            }
            return this.systemProperties;
        }

        void systemProperties(Transition<SystemProperties> systemProperties) {
            this.systemProperties = systemProperties;
            this.systemPropertiesBuildStage = 1;
        }

        InitTempDirectory initTempDirectory() {
            if (this.initTempDirectoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initTempDirectoryBuildStage == 0) {
                this.initTempDirectoryBuildStage = (byte)-1;
                InitTempDirectory computedValue = ImmutableMongoRestore.super.initTempDirectory();
                this.initTempDirectory = Objects.requireNonNull(computedValue, "initTempDirectory");
                this.initTempDirectoryBuildStage = 1;
            }
            return this.initTempDirectory;
        }

        void initTempDirectory(InitTempDirectory initTempDirectory) {
            this.initTempDirectory = initTempDirectory;
            this.initTempDirectoryBuildStage = 1;
        }

        Transition<ProcessWorkingDir> processWorkingDir() {
            if (this.processWorkingDirBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processWorkingDirBuildStage == 0) {
                this.processWorkingDirBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.processWorkingDir();
                this.processWorkingDir = Objects.requireNonNull(computedValue, "processWorkingDir");
                this.processWorkingDirBuildStage = 1;
            }
            return this.processWorkingDir;
        }

        void processWorkingDir(Transition<ProcessWorkingDir> processWorkingDir) {
            this.processWorkingDir = processWorkingDir;
            this.processWorkingDirBuildStage = 1;
        }

        Transition<Platform> platform() {
            if (this.platformBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.platformBuildStage == 0) {
                this.platformBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.platform();
                this.platform = Objects.requireNonNull(computedValue, "platform");
                this.platformBuildStage = 1;
            }
            return this.platform;
        }

        void platform(Transition<Platform> platform) {
            this.platform = platform;
            this.platformBuildStage = 1;
        }

        Transition<Distribution> distribution() {
            if (this.distributionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.distributionBuildStage == 0) {
                this.distributionBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.distribution();
                this.distribution = Objects.requireNonNull(computedValue, "distribution");
                this.distributionBuildStage = 1;
            }
            return this.distribution;
        }

        void distribution(Transition<Distribution> distribution) {
            this.distribution = distribution;
            this.distributionBuildStage = 1;
        }

        Transition<DistributionBaseUrl> distributionBaseUrl() {
            if (this.distributionBaseUrlBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.distributionBaseUrlBuildStage == 0) {
                this.distributionBaseUrlBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.distributionBaseUrl();
                this.distributionBaseUrl = Objects.requireNonNull(computedValue, "distributionBaseUrl");
                this.distributionBaseUrlBuildStage = 1;
            }
            return this.distributionBaseUrl;
        }

        void distributionBaseUrl(Transition<DistributionBaseUrl> distributionBaseUrl) {
            this.distributionBaseUrl = distributionBaseUrl;
            this.distributionBaseUrlBuildStage = 1;
        }

        ImmutableStart<ProcessConfig> processConfig() {
            if (this.processConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processConfigBuildStage == 0) {
                this.processConfigBuildStage = (byte)-1;
                ImmutableStart computedValue = ImmutableMongoRestore.super.processConfig();
                this.processConfig = Objects.requireNonNull(computedValue, "processConfig");
                this.processConfigBuildStage = 1;
            }
            return this.processConfig;
        }

        void processConfig(ImmutableStart<ProcessConfig> processConfig) {
            this.processConfig = processConfig;
            this.processConfigBuildStage = 1;
        }

        Transition<ProcessEnv> processEnv() {
            if (this.processEnvBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processEnvBuildStage == 0) {
                this.processEnvBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.processEnv();
                this.processEnv = Objects.requireNonNull(computedValue, "processEnv");
                this.processEnvBuildStage = 1;
            }
            return this.processEnv;
        }

        void processEnv(Transition<ProcessEnv> processEnv) {
            this.processEnv = processEnv;
            this.processEnvBuildStage = 1;
        }

        Transition<StartTimeout> startTimeout() {
            if (this.startTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startTimeoutBuildStage == 0) {
                this.startTimeoutBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.startTimeout();
                this.startTimeout = Objects.requireNonNull(computedValue, "startTimeout");
                this.startTimeoutBuildStage = 1;
            }
            return this.startTimeout;
        }

        void startTimeout(Transition<StartTimeout> startTimeout) {
            this.startTimeout = startTimeout;
            this.startTimeoutBuildStage = 1;
        }

        Transition<ProcessOutput> processOutput() {
            if (this.processOutputBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processOutputBuildStage == 0) {
                this.processOutputBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.processOutput();
                this.processOutput = Objects.requireNonNull(computedValue, "processOutput");
                this.processOutputBuildStage = 1;
            }
            return this.processOutput;
        }

        void processOutput(Transition<ProcessOutput> processOutput) {
            this.processOutput = processOutput;
            this.processOutputBuildStage = 1;
        }

        Transition<SupportConfig> supportConfig() {
            if (this.supportConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportConfigBuildStage == 0) {
                this.supportConfigBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.supportConfig();
                this.supportConfig = Objects.requireNonNull(computedValue, "supportConfig");
                this.supportConfigBuildStage = 1;
            }
            return this.supportConfig;
        }

        void supportConfig(Transition<SupportConfig> supportConfig) {
            this.supportConfig = supportConfig;
            this.supportConfigBuildStage = 1;
        }

        Transition<Name> commandName() {
            if (this.commandNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commandNameBuildStage == 0) {
                this.commandNameBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.commandName();
                this.commandName = Objects.requireNonNull(computedValue, "commandName");
                this.commandNameBuildStage = 1;
            }
            return this.commandName;
        }

        void commandName(Transition<Name> commandName) {
            this.commandName = commandName;
            this.commandNameBuildStage = 1;
        }

        Transition<PersistentDir> persistentBaseDir() {
            if (this.persistentBaseDirBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.persistentBaseDirBuildStage == 0) {
                this.persistentBaseDirBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.persistentBaseDir();
                this.persistentBaseDir = Objects.requireNonNull(computedValue, "persistentBaseDir");
                this.persistentBaseDirBuildStage = 1;
            }
            return this.persistentBaseDir;
        }

        void persistentBaseDir(Transition<PersistentDir> persistentBaseDir) {
            this.persistentBaseDir = persistentBaseDir;
            this.persistentBaseDirBuildStage = 1;
        }

        Transition<DownloadCache> downloadCache() {
            if (this.downloadCacheBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.downloadCacheBuildStage == 0) {
                this.downloadCacheBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.downloadCache();
                this.downloadCache = Objects.requireNonNull(computedValue, "downloadCache");
                this.downloadCacheBuildStage = 1;
            }
            return this.downloadCache;
        }

        void downloadCache(Transition<DownloadCache> downloadCache) {
            this.downloadCache = downloadCache;
            this.downloadCacheBuildStage = 1;
        }

        Transition<ExtractedFileSetStore> extractedFileSetStore() {
            if (this.extractedFileSetStoreBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extractedFileSetStoreBuildStage == 0) {
                this.extractedFileSetStoreBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.extractedFileSetStore();
                this.extractedFileSetStore = Objects.requireNonNull(computedValue, "extractedFileSetStore");
                this.extractedFileSetStoreBuildStage = 1;
            }
            return this.extractedFileSetStore;
        }

        void extractedFileSetStore(Transition<ExtractedFileSetStore> extractedFileSetStore) {
            this.extractedFileSetStore = extractedFileSetStore;
            this.extractedFileSetStoreBuildStage = 1;
        }

        DownloadPackage downloadPackage() {
            if (this.downloadPackageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.downloadPackageBuildStage == 0) {
                this.downloadPackageBuildStage = (byte)-1;
                DownloadPackage computedValue = ImmutableMongoRestore.super.downloadPackage();
                this.downloadPackage = Objects.requireNonNull(computedValue, "downloadPackage");
                this.downloadPackageBuildStage = 1;
            }
            return this.downloadPackage;
        }

        void downloadPackage(DownloadPackage downloadPackage) {
            this.downloadPackage = downloadPackage;
            this.downloadPackageBuildStage = 1;
        }

        Transition<ProgressListener> progressListener() {
            if (this.progressListenerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.progressListenerBuildStage == 0) {
                this.progressListenerBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.progressListener();
                this.progressListener = Objects.requireNonNull(computedValue, "progressListener");
                this.progressListenerBuildStage = 1;
            }
            return this.progressListener;
        }

        void progressListener(Transition<ProgressListener> progressListener) {
            this.progressListener = progressListener;
            this.progressListenerBuildStage = 1;
        }

        Transition<ExtractedFileSet> extractPackage() {
            if (this.extractPackageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extractPackageBuildStage == 0) {
                this.extractPackageBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.extractPackage();
                this.extractPackage = Objects.requireNonNull(computedValue, "extractPackage");
                this.extractPackageBuildStage = 1;
            }
            return this.extractPackage;
        }

        void extractPackage(Transition<ExtractedFileSet> extractPackage) {
            this.extractPackage = extractPackage;
            this.extractPackageBuildStage = 1;
        }

        Transition<Package> packageOfDistribution() {
            if (this.packageOfDistributionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.packageOfDistributionBuildStage == 0) {
                this.packageOfDistributionBuildStage = (byte)-1;
                Transition computedValue = ImmutableMongoRestore.super.packageOfDistribution();
                this.packageOfDistribution = Objects.requireNonNull(computedValue, "packageOfDistribution");
                this.packageOfDistributionBuildStage = 1;
            }
            return this.packageOfDistribution;
        }

        void packageOfDistribution(Transition<Package> packageOfDistribution) {
            this.packageOfDistribution = packageOfDistribution;
            this.packageOfDistributionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.systemEnvBuildStage == -1) {
                attributes.add("systemEnv");
            }
            if (this.systemPropertiesBuildStage == -1) {
                attributes.add("systemProperties");
            }
            if (this.initTempDirectoryBuildStage == -1) {
                attributes.add("initTempDirectory");
            }
            if (this.processWorkingDirBuildStage == -1) {
                attributes.add("processWorkingDir");
            }
            if (this.platformBuildStage == -1) {
                attributes.add("platform");
            }
            if (this.distributionBuildStage == -1) {
                attributes.add("distribution");
            }
            if (this.distributionBaseUrlBuildStage == -1) {
                attributes.add("distributionBaseUrl");
            }
            if (this.processConfigBuildStage == -1) {
                attributes.add("processConfig");
            }
            if (this.processEnvBuildStage == -1) {
                attributes.add("processEnv");
            }
            if (this.startTimeoutBuildStage == -1) {
                attributes.add("startTimeout");
            }
            if (this.processOutputBuildStage == -1) {
                attributes.add("processOutput");
            }
            if (this.supportConfigBuildStage == -1) {
                attributes.add("supportConfig");
            }
            if (this.commandNameBuildStage == -1) {
                attributes.add("commandName");
            }
            if (this.persistentBaseDirBuildStage == -1) {
                attributes.add("persistentBaseDir");
            }
            if (this.downloadCacheBuildStage == -1) {
                attributes.add("downloadCache");
            }
            if (this.extractedFileSetStoreBuildStage == -1) {
                attributes.add("extractedFileSetStore");
            }
            if (this.downloadPackageBuildStage == -1) {
                attributes.add("downloadPackage");
            }
            if (this.progressListenerBuildStage == -1) {
                attributes.add("progressListener");
            }
            if (this.extractPackageBuildStage == -1) {
                attributes.add("extractPackage");
            }
            if (this.packageOfDistributionBuildStage == -1) {
                attributes.add("packageOfDistribution");
            }
            return "Cannot build MongoRestore, attribute initializers form cycle " + attributes;
        }
    }
}

