/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.commands;

import de.flapdoodle.embed.mongo.commands.ImmutableServerAddress;
import java.net.InetAddress;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ServerAddress {
    @Value.Default
    public String getHost() {
        return ServerAddress.defaultHost();
    }

    @Value.Default
    public int getPort() {
        return ServerAddress.defaultPort();
    }

    @Value.Auxiliary
    public String toString() {
        return this.getHost() + ":" + this.getPort();
    }

    public static ImmutableServerAddress.Builder builder() {
        return ImmutableServerAddress.builder();
    }

    public static String defaultHost() {
        return "127.0.0.1";
    }

    public static int defaultPort() {
        return 27017;
    }

    public static ServerAddress of(InetAddress serverAddress, int port) {
        return ServerAddress.of(serverAddress.getHostName(), port);
    }

    public static ServerAddress of(String host, int port) {
        String hostToUse = host;
        if (hostToUse == null) {
            hostToUse = ServerAddress.defaultHost();
        }
        if ((hostToUse = hostToUse.trim()).length() == 0) {
            hostToUse = ServerAddress.defaultHost();
        }
        int portToUse = port;
        if (hostToUse.startsWith("[")) {
            int idx = host.indexOf("]");
            if (idx == -1) {
                throw new IllegalArgumentException("an IPV6 address must be encosed with '[' and ']' according to RFC 2732.");
            }
            int portIdx = host.indexOf("]:");
            if (portIdx != -1) {
                if (port != ServerAddress.defaultPort()) {
                    throw new IllegalArgumentException("can't specify port in construct and via host");
                }
                portToUse = Integer.parseInt(host.substring(portIdx + 2));
            }
            hostToUse = host.substring(1, idx);
        } else {
            int lastIdx;
            int idx = hostToUse.indexOf(":");
            if (idx == (lastIdx = hostToUse.lastIndexOf(":")) && idx > 0) {
                if (port != ServerAddress.defaultPort()) {
                    throw new IllegalArgumentException("can't specify port in construct and via host");
                }
                try {
                    portToUse = Integer.parseInt(hostToUse.substring(idx + 1));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("host and port should be specified in host:port format");
                }
                hostToUse = hostToUse.substring(0, idx).trim();
            }
        }
        return ServerAddress.builder().host(hostToUse.toLowerCase()).port(portToUse).build();
    }
}

