/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.commands;

import de.flapdoodle.embed.mongo.commands.MongosArguments;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableMongosArguments
extends MongosArguments {
    private final boolean verbose;
    private final String configDB;
    private final String replicaSet;

    private ImmutableMongosArguments(Builder builder) {
        this.configDB = builder.configDB;
        this.replicaSet = builder.replicaSet;
        this.verbose = builder.verboseIsSet() ? builder.verbose : super.verbose();
    }

    private ImmutableMongosArguments(boolean verbose, String configDB, String replicaSet) {
        this.verbose = verbose;
        this.configDB = configDB;
        this.replicaSet = replicaSet;
    }

    @Override
    public boolean verbose() {
        return this.verbose;
    }

    @Override
    public Optional<String> configDB() {
        return Optional.ofNullable(this.configDB);
    }

    @Override
    public Optional<String> replicaSet() {
        return Optional.ofNullable(this.replicaSet);
    }

    public final ImmutableMongosArguments withVerbose(boolean value) {
        if (this.verbose == value) {
            return this;
        }
        return new ImmutableMongosArguments(value, this.configDB, this.replicaSet);
    }

    public final ImmutableMongosArguments withConfigDB(String value) {
        String newValue = Objects.requireNonNull(value, "configDB");
        if (Objects.equals(this.configDB, newValue)) {
            return this;
        }
        return new ImmutableMongosArguments(this.verbose, newValue, this.replicaSet);
    }

    public final ImmutableMongosArguments withConfigDB(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.configDB, value)) {
            return this;
        }
        return new ImmutableMongosArguments(this.verbose, value, this.replicaSet);
    }

    public final ImmutableMongosArguments withReplicaSet(String value) {
        String newValue = Objects.requireNonNull(value, "replicaSet");
        if (Objects.equals(this.replicaSet, newValue)) {
            return this;
        }
        return new ImmutableMongosArguments(this.verbose, this.configDB, newValue);
    }

    public final ImmutableMongosArguments withReplicaSet(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.replicaSet, value)) {
            return this;
        }
        return new ImmutableMongosArguments(this.verbose, this.configDB, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongosArguments && this.equalTo(0, (ImmutableMongosArguments)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongosArguments another) {
        return this.verbose == another.verbose && Objects.equals(this.configDB, another.configDB) && Objects.equals(this.replicaSet, another.replicaSet);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.verbose);
        h += (h << 5) + Objects.hashCode(this.configDB);
        h += (h << 5) + Objects.hashCode(this.replicaSet);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongosArguments{");
        builder.append("verbose=").append(this.verbose);
        if (this.configDB != null) {
            builder.append(", ");
            builder.append("configDB=").append(this.configDB);
        }
        if (this.replicaSet != null) {
            builder.append(", ");
            builder.append("replicaSet=").append(this.replicaSet);
        }
        return builder.append("}").toString();
    }

    public static ImmutableMongosArguments copyOf(MongosArguments instance) {
        if (instance instanceof ImmutableMongosArguments) {
            return (ImmutableMongosArguments)instance;
        }
        return ImmutableMongosArguments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_VERBOSE = 1L;
        private long optBits;
        private boolean verbose;
        private String configDB;
        private String replicaSet;

        private Builder() {
        }

        public final Builder from(MongosArguments instance) {
            Optional<String> replicaSetOptional;
            Objects.requireNonNull(instance, "instance");
            this.verbose(instance.verbose());
            Optional<String> configDBOptional = instance.configDB();
            if (configDBOptional.isPresent()) {
                this.configDB(configDBOptional);
            }
            if ((replicaSetOptional = instance.replicaSet()).isPresent()) {
                this.replicaSet(replicaSetOptional);
            }
            return this;
        }

        public final Builder verbose(boolean verbose) {
            this.verbose = verbose;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configDB(String configDB) {
            this.configDB = Objects.requireNonNull(configDB, "configDB");
            return this;
        }

        public final Builder configDB(Optional<String> configDB) {
            this.configDB = configDB.orElse(null);
            return this;
        }

        public final Builder replicaSet(String replicaSet) {
            this.replicaSet = Objects.requireNonNull(replicaSet, "replicaSet");
            return this;
        }

        public final Builder replicaSet(Optional<String> replicaSet) {
            this.replicaSet = replicaSet.orElse(null);
            return this;
        }

        public ImmutableMongosArguments build() {
            return new ImmutableMongosArguments(this);
        }

        private boolean verboseIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

