package de.flapdoodle.embed.mongo.packageresolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NumericVersion}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNumericVersion.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNumericVersion.of()}.
 */
@Generated(from = "NumericVersion", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableNumericVersion implements NumericVersion {
  private final int major;
  private final int minor;
  private final int patch;

  private ImmutableNumericVersion(int major, int minor, int patch) {
    this.major = major;
    this.minor = minor;
    this.patch = patch;
  }

  /**
   * @return The value of the {@code major} attribute
   */
  @Override
  public int major() {
    return major;
  }

  /**
   * @return The value of the {@code minor} attribute
   */
  @Override
  public int minor() {
    return minor;
  }

  /**
   * @return The value of the {@code patch} attribute
   */
  @Override
  public int patch() {
    return patch;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NumericVersion#major() major} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for major
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNumericVersion withMajor(int value) {
    if (this.major == value) return this;
    return new ImmutableNumericVersion(value, this.minor, this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NumericVersion#minor() minor} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNumericVersion withMinor(int value) {
    if (this.minor == value) return this;
    return new ImmutableNumericVersion(this.major, value, this.patch);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NumericVersion#patch() patch} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for patch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNumericVersion withPatch(int value) {
    if (this.patch == value) return this;
    return new ImmutableNumericVersion(this.major, this.minor, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNumericVersion} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNumericVersion
        && equalTo((ImmutableNumericVersion) another);
  }

  private boolean equalTo(ImmutableNumericVersion another) {
    return major == another.major
        && minor == another.minor
        && patch == another.patch;
  }

  /**
   * Computes a hash code from attributes: {@code major}, {@code minor}, {@code patch}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + major;
    h += (h << 5) + minor;
    h += (h << 5) + patch;
    return h;
  }

  /**
   * Prints the immutable value {@code NumericVersion} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NumericVersion{"
        + "major=" + major
        + ", minor=" + minor
        + ", patch=" + patch
        + "}";
  }

  /**
   * Construct a new immutable {@code NumericVersion} instance.
   * @param major The value for the {@code major} attribute
   * @param minor The value for the {@code minor} attribute
   * @param patch The value for the {@code patch} attribute
   * @return An immutable NumericVersion instance
   */
  public static ImmutableNumericVersion of(int major, int minor, int patch) {
    return new ImmutableNumericVersion(major, minor, patch);
  }

  /**
   * Creates an immutable copy of a {@link NumericVersion} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NumericVersion instance
   */
  public static ImmutableNumericVersion copyOf(NumericVersion instance) {
    if (instance instanceof ImmutableNumericVersion) {
      return (ImmutableNumericVersion) instance;
    }
    return ImmutableNumericVersion.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNumericVersion ImmutableNumericVersion}.
   * <pre>
   * ImmutableNumericVersion.builder()
   *    .major(int) // required {@link NumericVersion#major() major}
   *    .minor(int) // required {@link NumericVersion#minor() minor}
   *    .patch(int) // required {@link NumericVersion#patch() patch}
   *    .build();
   * </pre>
   * @return A new ImmutableNumericVersion builder
   */
  public static ImmutableNumericVersion.Builder builder() {
    return new ImmutableNumericVersion.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNumericVersion ImmutableNumericVersion}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NumericVersion", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MAJOR = 0x1L;
    private static final long INIT_BIT_MINOR = 0x2L;
    private static final long INIT_BIT_PATCH = 0x4L;
    private long initBits = 0x7L;

    private int major;
    private int minor;
    private int patch;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NumericVersion} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NumericVersion instance) {
      Objects.requireNonNull(instance, "instance");
      major(instance.major());
      minor(instance.minor());
      patch(instance.patch());
      return this;
    }

    /**
     * Initializes the value for the {@link NumericVersion#major() major} attribute.
     * @param major The value for major 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder major(int major) {
      this.major = major;
      initBits &= ~INIT_BIT_MAJOR;
      return this;
    }

    /**
     * Initializes the value for the {@link NumericVersion#minor() minor} attribute.
     * @param minor The value for minor 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder minor(int minor) {
      this.minor = minor;
      initBits &= ~INIT_BIT_MINOR;
      return this;
    }

    /**
     * Initializes the value for the {@link NumericVersion#patch() patch} attribute.
     * @param patch The value for patch 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder patch(int patch) {
      this.patch = patch;
      initBits &= ~INIT_BIT_PATCH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNumericVersion ImmutableNumericVersion}.
     * @return An immutable instance of NumericVersion
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNumericVersion build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNumericVersion(major, minor, patch);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MAJOR) != 0) attributes.add("major");
      if ((initBits & INIT_BIT_MINOR) != 0) attributes.add("minor");
      if ((initBits & INIT_BIT_PATCH) != 0) attributes.add("patch");
      return "Cannot build NumericVersion, some of required attributes are not set " + attributes;
    }
  }
}
