/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.docconverter.api;

import de.elnarion.util.docconverter.api.ConversionJob;
import de.elnarion.util.docconverter.api.ConversionJobWithInputUnspecified;
import de.elnarion.util.docconverter.api.ConversionJobWithSourceDocTypeUnspecified;
import de.elnarion.util.docconverter.api.ConversionJobWithTargetDocTypeUnspecified;
import de.elnarion.util.docconverter.api.exception.ConversionException;
import de.elnarion.util.docconverter.api.exception.EmptyMimeTypeException;
import de.elnarion.util.docconverter.api.exception.InputUnavailableException;
import de.elnarion.util.docconverter.api.exception.MimeTypeNotSupportedException;
import de.elnarion.util.docconverter.spi.DocConverter;
import de.elnarion.util.docconverter.spi.DocConverterManager;
import de.elnarion.util.docconverter.spi.DocConverterManagerInterface;
import de.elnarion.util.docconverter.spi.DocConverterProvider;
import de.elnarion.util.docconverter.spi.InputType;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

public class ConversionJobFactory {
    private static ConversionJobFactory conversionJobFactory;

    protected ConversionJobFactory() {
    }

    public static synchronized ConversionJobFactory getInstance() {
        if (conversionJobFactory == null) {
            conversionJobFactory = new ConversionJobFactory();
        }
        return conversionJobFactory;
    }

    public ConversionJobWithInputUnspecified createEmptyConversionJob() {
        return new ConversionJobImpl(DocConverterManager.getInstance(), new HashMap());
    }

    public ConversionJobWithInputUnspecified createEmptyConversionJob(Map<String, Object> paramConfigParameters) {
        return new ConversionJobImpl(DocConverterManager.getInstance(), paramConfigParameters);
    }

    public ConversionJobWithInputUnspecified createEmptyConversionJob(ClassLoader paramClassLoader) {
        return new ConversionJobImpl(DocConverterManager.getInstance(paramClassLoader), new HashMap());
    }

    public ConversionJobWithInputUnspecified createEmptyConversionJob(Map<String, Object> paramConfigParameters, ClassLoader paramClassLoader) {
        return new ConversionJobImpl(DocConverterManager.getInstance(paramClassLoader), paramConfigParameters);
    }

    private class ConversionJobImpl
    implements ConversionJob,
    ConversionJobWithSourceDocTypeUnspecified,
    ConversionJobWithTargetDocTypeUnspecified,
    ConversionJobWithInputUnspecified {
        private String sourceMimeType;
        private String targetMimeType;
        private DocConverterManagerInterface docConverterManager;
        private List<InputStream> sourceInputStreams;
        private List<File> sourceFiles;
        private Map<DocConverterProvider, Set<String>> docConverterProviderTargetMapping;
        private DocConverter docConverter;
        private Map<String, Object> configurationParameters;

        private ConversionJobImpl(DocConverterManagerInterface paramDocConverterManager, Map<String, Object> paramDocConverterConfiguration) {
            this.docConverterManager = paramDocConverterManager;
            this.configurationParameters = paramDocConverterConfiguration;
        }

        @Override
        public ConversionJob toMimeType(String paramTargetMimetype) throws ConversionException {
            if (paramTargetMimetype == null) {
                throw new EmptyMimeTypeException("A null value as target MIME-Type is not allowed");
            }
            boolean fileInput = true;
            if (this.sourceFiles == null) {
                fileInput = false;
            }
            Set<DocConverterProvider> docConverterProviders = this.docConverterProviderTargetMapping.keySet();
            for (DocConverterProvider docConverterProvider : docConverterProviders) {
                Set<String> targetMimeTypes = this.docConverterProviderTargetMapping.get(docConverterProvider);
                if (!targetMimeTypes.contains(paramTargetMimetype) || (fileInput || !docConverterProvider.isInputTypeSupported(InputType.INPUTSTREAM)) && (!fileInput || !docConverterProvider.isInputTypeSupported(InputType.FILE))) continue;
                this.docConverter = docConverterProvider.createDocConverter(this.configurationParameters);
                break;
            }
            if (this.docConverter == null) {
                throw new MimeTypeNotSupportedException("The specified target MIME-Type " + paramTargetMimetype + "is not supported for source MIME-Type" + this.sourceMimeType);
            }
            this.targetMimeType = paramTargetMimetype;
            return this;
        }

        @Override
        public ConversionJobWithTargetDocTypeUnspecified fromMimeType(String paramMimetype) throws ConversionException {
            if (paramMimetype == null) {
                throw new EmptyMimeTypeException("No source MIME-Type specified!");
            }
            this.docConverterProviderTargetMapping = this.docConverterManager.getDocConverterProviderTargetMappingForSourceMimeType(paramMimetype);
            if (this.docConverterProviderTargetMapping == null || this.docConverterProviderTargetMapping.isEmpty()) {
                throw new MimeTypeNotSupportedException("No document converter found for the specified MIME-Type " + paramMimetype);
            }
            this.sourceMimeType = paramMimetype;
            return this;
        }

        @Override
        public ConversionJobWithSourceDocTypeUnspecified fromStreams(List<InputStream> paramInputstreams) throws ConversionException {
            if (paramInputstreams == null) {
                throw new InputUnavailableException("Null is not allowed as input parameter.");
            }
            this.sourceInputStreams = paramInputstreams;
            return this;
        }

        @Override
        public ConversionJobWithSourceDocTypeUnspecified fromFiles(List<File> paramFiles) throws ConversionException {
            if (paramFiles == null) {
                throw new InputUnavailableException("Null is not allowed as input parameter.");
            }
            this.sourceFiles = paramFiles;
            for (File file : paramFiles) {
                if (file.exists()) continue;
                throw new InputUnavailableException("The specified file could not be found!");
            }
            return this;
        }

        @Override
        public Future<List<InputStream>> convert() throws ConversionException {
            if (this.sourceInputStreams != null) {
                return this.docConverter.convertStreams(this.sourceInputStreams, this.sourceMimeType, this.targetMimeType);
            }
            return this.docConverter.convertFiles(this.sourceFiles, this.sourceMimeType, this.targetMimeType);
        }
    }
}

