/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.util;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Classes {
    private static final Logger logger = LoggerFactory.getLogger(Classes.class);
    private static final Set<Class<?>> WRAPPER_TYPES = Classes.getWrapperTypes();
    private static final Collection<Class<?>> PRIMITIVE_NUMERIC_TYPES = Classes.getPrimitiveNumericTypes();

    private Classes() {
    }

    private static Set<Class<?>> getWrapperTypes() {
        HashSet wrapperTypes = new HashSet();
        wrapperTypes.add(Boolean.class);
        wrapperTypes.add(Character.class);
        wrapperTypes.add(Byte.class);
        wrapperTypes.add(Short.class);
        wrapperTypes.add(Integer.class);
        wrapperTypes.add(Long.class);
        wrapperTypes.add(Float.class);
        wrapperTypes.add(Double.class);
        wrapperTypes.add(Void.class);
        return wrapperTypes;
    }

    public static boolean isPrimitiveNumericType(Class<?> clazz) {
        return PRIMITIVE_NUMERIC_TYPES.contains(clazz);
    }

    private static Collection<Class<?>> getPrimitiveNumericTypes() {
        HashSet numericTypes = new HashSet();
        numericTypes.add(Character.TYPE);
        numericTypes.add(Byte.TYPE);
        numericTypes.add(Short.TYPE);
        numericTypes.add(Integer.TYPE);
        numericTypes.add(Long.TYPE);
        numericTypes.add(Float.TYPE);
        numericTypes.add(Double.TYPE);
        return numericTypes;
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return clazz != null && clazz.isPrimitive();
    }

    public static boolean isPrimitiveWrapperType(Class<?> clazz) {
        return clazz != null && WRAPPER_TYPES.contains(clazz);
    }

    public static boolean isSimpleType(Class<?> clazz) {
        return Classes.isPrimitiveType(clazz) || Classes.isPrimitiveWrapperType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || URI.class.equals(clazz) || URL.class.equals(clazz) || Locale.class.equals(clazz) || Class.class.equals(clazz);
    }

    public static <T> T freshInstanceOf(Class<T> clazz) {
        Constructor<T> constructor;
        if (clazz == null) {
            return null;
        }
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.debug("Missing default constructor for type {}. Assuming standard default values for primitive properties.", (Object)clazz.getName());
            return null;
        }
        boolean accessibility = constructor.isAccessible();
        try {
            constructor.setAccessible(true);
            T t = constructor.newInstance(new Object[0]);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            constructor.setAccessible(accessibility);
        }
    }

    public static Set<Class<?>> typesOf(Object ... values) {
        HashSet types = new HashSet(values.length);
        for (Object value : values) {
            if (value == null) continue;
            types.add(value.getClass());
        }
        return types;
    }

    public static boolean allAssignableFrom(Class<?> sharedType, Iterable<? extends Class<?>> types) {
        boolean matching = true;
        for (Class<?> type : types) {
            if (sharedType.isAssignableFrom(type)) continue;
            matching = false;
        }
        return matching;
    }
}

