/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractContentNotifier;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class TelegramNotifier
extends AbstractContentNotifier {
    private static final String DEFAULT_MESSAGE = "<strong>#{name}</strong>/#{id} is <strong>#{status}</strong>";
    private RestTemplate restTemplate;
    private String apiUrl = "https://api.telegram.org";
    private @Nullable String chatId;
    private @Nullable String authToken;
    private String parseMode = "HTML";
    private boolean disableNotify = false;

    public TelegramNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> this.restTemplate.getForObject(this.buildUrl(), Void.class, this.createMessage(event, instance)));
    }

    protected String buildUrl() {
        return String.format("%s/bot%s/sendmessage?chat_id={chat_id}&text={text}&parse_mode={parse_mode}&disable_notification={disable_notification}", this.apiUrl, this.authToken);
    }

    private Map<String, Object> createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("chat_id", this.chatId);
        parameters.put("parse_mode", this.parseMode);
        parameters.put("disable_notification", this.disableNotify);
        parameters.put("text", this.createContent(event, instance));
        return parameters;
    }

    @Override
    protected String getDefaultMessage() {
        return DEFAULT_MESSAGE;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public @Nullable String getChatId() {
        return this.chatId;
    }

    public void setChatId(@Nullable String chatId) {
        this.chatId = chatId;
    }

    public @Nullable String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String authToken) {
        this.authToken = authToken;
    }

    public boolean isDisableNotify() {
        return this.disableNotify;
    }

    public void setDisableNotify(boolean disableNotify) {
        this.disableNotify = disableNotify;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }
}

