/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.HashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.MapAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class OpsGenieNotifier
extends AbstractStatusChangeNotifier {
    private static final URI DEFAULT_URI = URI.create("https://api.opsgenie.com/v2/alerts");
    private static final String DEFAULT_MESSAGE = "#{instance.registration.name}/#{instance.id} is #{instance.statusInfo.status}";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate;
    private URI url = DEFAULT_URI;
    private @Nullable String apiKey;
    private @Nullable String actions;
    private @Nullable String source;
    private @Nullable String tags;
    private @Nullable String entity;
    private @Nullable String user;
    private Expression description;

    public OpsGenieNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
        this.description = this.parser.parseExpression(DEFAULT_MESSAGE, ParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> this.restTemplate.exchange(this.buildUrl(event, instance), HttpMethod.POST, this.createRequest(event, instance), Void.class, new Object[0]));
    }

    protected String buildUrl(InstanceEvent event, Instance instance) {
        InstanceStatusChangedEvent statusChangedEvent;
        if (event instanceof InstanceStatusChangedEvent && "UP".equals((statusChangedEvent = (InstanceStatusChangedEvent)event).getStatusInfo().getStatus())) {
            return String.format("%s/%s/close?identifierType=alias", this.url, this.generateAlias(instance));
        }
        return this.url.toString();
    }

    protected HttpEntity<?> createRequest(InstanceEvent event, Instance instance) {
        InstanceStatusChangedEvent statusChangedEvent;
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.user != null) {
            body.put("user", this.user);
        }
        if (this.source != null) {
            body.put("source", this.source);
        }
        if (event instanceof InstanceStatusChangedEvent && !"UP".equals((statusChangedEvent = (InstanceStatusChangedEvent)event).getStatusInfo().getStatus())) {
            body.put("message", this.getMessage(event, instance));
            body.put("alias", this.generateAlias(instance));
            body.put("description", this.getDescription(event, instance));
            if (this.actions != null) {
                body.put("actions", this.actions);
            }
            if (this.tags != null) {
                body.put("tags", this.tags);
            }
            if (this.entity != null) {
                body.put("entity", this.entity);
            }
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("type", "link");
            details.put("href", instance.getRegistration().getHealthUrl());
            details.put("text", "Instance health-endpoint");
            body.put("details", details);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "GenieKey " + this.apiKey);
        return new HttpEntity(body, headers);
    }

    protected String generateAlias(Instance instance) {
        return instance.getRegistration().getName() + "_" + String.valueOf(instance.getId());
    }

    protected @Nullable String getMessage(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        SimpleEvaluationContext context = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{DataBindingPropertyAccessor.forReadOnlyAccess(), new MapAccessor()}).withRootObject(root).build();
        return (String)this.description.getValue((EvaluationContext)context, String.class);
    }

    protected String getDescription(InstanceEvent event, Instance instance) {
        return String.format("Instance %s (%s) went from %s to %s", instance.getRegistration().getName(), instance.getId(), this.getLastStatus(instance.getId()), ((InstanceStatusChangedEvent)event).getStatusInfo().getStatus());
    }

    public @Nullable String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(@Nullable String apiKey) {
        this.apiKey = apiKey;
    }

    public void setDescription(String description) {
        this.description = this.parser.parseExpression(description, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getMessage() {
        return this.description.getExpressionString();
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public @Nullable String getActions() {
        return this.actions;
    }

    public void setActions(@Nullable String actions) {
        this.actions = actions;
    }

    public @Nullable String getSource() {
        return this.source;
    }

    public void setSource(@Nullable String source) {
        this.source = source;
    }

    public @Nullable String getTags() {
        return this.tags;
    }

    public void setTags(@Nullable String tags) {
        this.tags = tags;
    }

    public @Nullable String getEntity() {
        return this.entity;
    }

    public void setEntity(@Nullable String entity) {
        this.entity = entity;
    }

    public @Nullable String getUser() {
        return this.user;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }
}

