/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractContentNotifier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class LetsChatNotifier
extends AbstractContentNotifier {
    private static final String DEFAULT_MESSAGE = "*#{name}* (#{id}) is *#{status}*";
    private RestTemplate restTemplate;
    private @Nullable URI url;
    private @Nullable String room;
    private @Nullable String token;
    private String username = "Spring Boot Admin";

    public LetsChatNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String auth = Base64.getEncoder().encodeToString(String.format("%s:%s", this.token, this.username).getBytes(StandardCharsets.UTF_8));
        headers.add("Authorization", String.format("Basic %s", auth));
        return Mono.fromRunnable(() -> this.restTemplate.exchange(this.createUrl(), HttpMethod.POST, new HttpEntity(this.createMessage(event, instance), headers), Void.class));
    }

    private URI createUrl() {
        if (this.url == null) {
            throw new IllegalStateException("'url' must not be null.");
        }
        return URI.create(String.format("%s/rooms/%s/messages", this.url, this.room));
    }

    protected Object createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, String> messageJson = new HashMap<String, String>();
        messageJson.put("text", this.createContent(event, instance));
        return messageJson;
    }

    @Override
    protected String getDefaultMessage() {
        return DEFAULT_MESSAGE;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public @Nullable URI getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable URI url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public @Nullable String getRoom() {
        return this.room;
    }

    public void setRoom(@Nullable String room) {
        this.room = room;
    }

    public @Nullable String getToken() {
        return this.token;
    }

    public void setToken(@Nullable String token) {
        this.token = token;
    }
}

