/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.utils.jackson;

import de.codecentric.boot.admin.server.domain.values.Registration;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.deser.std.StdDeserializer;

public class RegistrationDeserializer
extends StdDeserializer<Registration> {
    public RegistrationDeserializer() {
        super(Registration.class);
    }

    public Registration deserialize(JsonParser p, DeserializationContext ctxt) {
        JsonNode node = (JsonNode)p.readValueAsTree();
        Registration.Builder builder = Registration.builder();
        builder.name(this.firstNonNullAsText(node, "name"));
        if (node.hasNonNull("url")) {
            String url = this.firstNonNullAsText(node, "url");
            builder.healthUrl(url.replaceFirst("/+$", "") + "/health").managementUrl(url);
        } else {
            builder.healthUrl(this.firstNonNullAsText(node, "healthUrl", "health_url"));
            builder.managementUrl(this.firstNonNullAsText(node, "managementUrl", "management_url"));
            builder.serviceUrl(this.firstNonNullAsText(node, "serviceUrl", "service_url"));
        }
        if (node.has("metadata")) {
            node.get("metadata").properties().forEach(entry -> builder.metadata((String)entry.getKey(), ((JsonNode)entry.getValue()).asText()));
        }
        builder.source(this.firstNonNullAsText(node, "source"));
        return builder.build();
    }

    private String firstNonNullAsText(JsonNode node, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            if (!node.hasNonNull(fieldName)) continue;
            return node.get(fieldName).asText();
        }
        return null;
    }
}

