/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractContentNotifier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;
import tools.jackson.databind.json.JsonMapper;

public class FeiShuNotifier
extends AbstractContentNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeiShuNotifier.class);
    private RestTemplate restTemplate;
    private URI webhookUrl;
    private boolean atAll = true;
    private String secret;
    private MessageType messageType = MessageType.interactive;
    private Card card = new Card();

    public FeiShuNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        if (this.webhookUrl == null) {
            return Mono.error((Throwable)new IllegalStateException("'webhookUrl' must not be null."));
        }
        return Mono.fromRunnable(() -> {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.webhookUrl, this.createNotification(event, instance), String.class);
            log.debug("Send a notification message to the FeiShu group,returns the parameter\uff1a{}", responseEntity.getBody());
        });
    }

    private String generateSign(String secret, long timestamp) {
        try {
            String stringToSign = timestamp + "\n" + secret;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(stringToSign.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signData = mac.doFinal(new byte[0]);
            return new String(Base64.getEncoder().encode(signData));
        }
        catch (Exception ex) {
            log.error("Description Failed to generate the Webhook signature of the FeiShu\uff1a{}", (Object)ex.getMessage());
            return null;
        }
    }

    protected HttpEntity<Map<String, Object>> createNotification(InstanceEvent event, Instance instance) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("receive_id", UUID.randomUUID().toString());
        if (StringUtils.hasText((String)this.secret)) {
            long timestamp = Instant.now().getEpochSecond();
            body.put("timestamp", timestamp);
            body.put("sign", this.generateSign(this.secret, timestamp));
        }
        body.put("msg_type", (Object)this.messageType);
        switch (this.messageType) {
            case interactive: {
                body.put("card", this.createCardContent(event, instance));
                break;
            }
            default: {
                body.put("content", this.createTextContent(event, instance));
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("User-Agent", "Codecentric's Spring Boot Admin");
        return new HttpEntity(body, headers);
    }

    @Override
    protected Map<String, Object> buildContentModel(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        return root;
    }

    @Override
    protected String getDefaultMessage() {
        return "ServiceName: #{instance.registration.name}(#{instance.id}) \nServiceUrl: #{instance.registration.serviceUrl} \nStatus: changed status from [#{lastStatus}] to [#{event.statusInfo.status}]";
    }

    private String createTextContent(InstanceEvent event, Instance instance) {
        HashMap<String, Object> textContent = new HashMap<String, Object>();
        Object content = this.createContent(event, instance);
        if (this.atAll) {
            content = (String)content + "\n<at user_id=\"all\">@all</at>";
        }
        textContent.put("text", content);
        return this.toJsonString(textContent);
    }

    private String createCardContent(InstanceEvent event, Instance instance) {
        String content = this.createContent(event, instance);
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("template", StringUtils.hasText((String)this.card.getThemeColor()) ? "red" : this.card.getThemeColor());
        HashMap<String, String> titleContent = new HashMap<String, String>();
        titleContent.put("tag", "plain_text");
        titleContent.put("content", this.card.getTitle());
        header.put("title", titleContent);
        ArrayList elements = new ArrayList();
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("tag", "div");
        HashMap<String, String> text = new HashMap<String, String>();
        text.put("tag", "plain_text");
        text.put("content", content);
        item.put("text", text);
        elements.add(item);
        if (this.atAll) {
            HashMap<String, Object> atItem = new HashMap<String, Object>();
            atItem.put("tag", "div");
            HashMap<String, String> atText = new HashMap<String, String>();
            atText.put("tag", "lark_md");
            atText.put("content", "<at id=all></at>");
            atItem.put("text", atText);
            elements.add(atItem);
        }
        HashMap<String, Cloneable> cardContent = new HashMap<String, Cloneable>();
        cardContent.put("header", header);
        cardContent.put("elements", elements);
        return this.toJsonString(cardContent);
    }

    private String toJsonString(Object o) {
        try {
            JsonMapper jsonMapper = JsonMapper.builder().build();
            return jsonMapper.writeValueAsString(o);
        }
        catch (Exception ex) {
            log.warn("Failed to serialize JSON object", (Throwable)ex);
            return null;
        }
    }

    public URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(URI webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public boolean isAtAll() {
        return this.atAll;
    }

    public void setAtAll(boolean atAll) {
        this.atAll = atAll;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public static enum MessageType {
        text,
        interactive;

    }

    public static class Card {
        private String title = "Codecentric's Spring Boot Admin notice";
        private String themeColor = "red";

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getThemeColor() {
            return this.themeColor;
        }

        public void setThemeColor(String themeColor) {
            this.themeColor = themeColor;
        }
    }
}

