/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.codecentric.boot.admin.server.domain.values.Registration;
import java.io.IOException;

public class RegistrationDeserializer
extends StdDeserializer<Registration> {
    private static final long serialVersionUID = 1L;

    public RegistrationDeserializer() {
        super(Registration.class);
    }

    public Registration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        Registration.Builder builder = Registration.builder();
        builder.name(this.firstNonNullAsText(node, "name"));
        if (node.hasNonNull("url")) {
            String url = this.firstNonNullAsText(node, "url");
            builder.healthUrl(url.replaceFirst("/+$", "") + "/health").managementUrl(url);
        } else {
            builder.healthUrl(this.firstNonNullAsText(node, "healthUrl", "health_url"));
            builder.managementUrl(this.firstNonNullAsText(node, "managementUrl", "management_url"));
            builder.serviceUrl(this.firstNonNullAsText(node, "serviceUrl", "service_url"));
        }
        if (node.has("metadata")) {
            node.get("metadata").properties().forEach(entry -> builder.metadata((String)entry.getKey(), ((JsonNode)entry.getValue()).asText()));
        }
        builder.source(this.firstNonNullAsText(node, "source"));
        return builder.build();
    }

    private String firstNonNullAsText(JsonNode node, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            if (!node.hasNonNull(fieldName)) continue;
            return node.get(fieldName).asText();
        }
        return null;
    }
}

