/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.values.InstanceId;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import lombok.Generated;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class IntervalCheck {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntervalCheck.class);
    private final String name;
    private final Map<InstanceId, Instant> lastChecked = new ConcurrentHashMap<InstanceId, Instant>();
    private final Function<InstanceId, Mono<Void>> checkFn;
    private Duration maxBackoff;
    private Duration interval;
    private Duration minRetention;
    @Nullable
    private Disposable subscription;
    @Nullable
    private Scheduler scheduler;
    @NonNull
    private Consumer<Throwable> retryConsumer;

    public IntervalCheck(String name, Function<InstanceId, Mono<Void>> checkFn, Duration interval, Duration minRetention, Duration maxBackoff) {
        this.name = name;
        this.retryConsumer = throwable -> log.warn("Unexpected error in {}-check", (Object)this.name, throwable);
        this.checkFn = checkFn;
        this.interval = interval;
        this.minRetention = minRetention;
        this.maxBackoff = maxBackoff;
    }

    public void start() {
        this.scheduler = Schedulers.newSingle((String)(this.name + "-check"));
        this.subscription = Flux.interval((Duration)this.interval).onBackpressureLatest().doOnSubscribe(s -> log.debug("Scheduled {}-check every {}", (Object)this.name, (Object)this.interval)).log(log.getName(), Level.FINEST, new SignalType[0]).subscribeOn(this.scheduler).flatMap(i -> this.checkAllInstances(), Math.max(1, Runtime.getRuntime().availableProcessors() / 2)).retryWhen(this.createRetrySpec()).subscribe(null, error -> log.error("Unexpected error in {}-check", (Object)this.name, error));
    }

    private Retry createRetrySpec() {
        return Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofSeconds(1L)).maxBackoff(this.maxBackoff).doBeforeRetry(s -> this.retryConsumer.accept(s.failure()));
    }

    public void markAsChecked(InstanceId instanceId) {
        this.lastChecked.put(instanceId, Instant.now());
    }

    protected Publisher<Void> checkAllInstances() {
        log.debug("check {} for all instances", (Object)this.name);
        Instant expiration = Instant.now().minus(this.minRetention);
        return Flux.fromIterable(this.lastChecked.entrySet()).filter(entry -> ((Instant)entry.getValue()).isBefore(expiration)).map(Map.Entry::getKey).flatMap(this.checkFn).then();
    }

    public void stop() {
        if (this.subscription != null) {
            this.subscription.dispose();
            this.subscription = null;
        }
        if (this.scheduler != null) {
            this.scheduler.dispose();
            this.scheduler = null;
        }
    }

    @Generated
    public void setMaxBackoff(Duration maxBackoff) {
        this.maxBackoff = maxBackoff;
    }

    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @Generated
    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    @Generated
    public void setMinRetention(Duration minRetention) {
        this.minRetention = minRetention;
    }

    @Generated
    public void setRetryConsumer(@NonNull Consumer<Throwable> retryConsumer) {
        if (retryConsumer == null) {
            throw new NullPointerException("retryConsumer is marked non-null but is null");
        }
        this.retryConsumer = retryConsumer;
    }
}

