/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify.filter;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

public abstract class AbstractContentNotifier
extends AbstractStatusChangeNotifier {
    private Expression message;
    private final SpelExpressionParser parser = new SpelExpressionParser();

    public AbstractContentNotifier(InstanceRepository repository) {
        super(repository);
        this.message = this.parser.parseExpression(this.getDefaultMessage(), ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getMessage() {
        return this.message.getExpressionString();
    }

    public void setMessage(String message) {
        this.message = this.parser.parseExpression(message, ParserContext.TEMPLATE_EXPRESSION);
    }

    protected String createContent(InstanceEvent event, Instance instance) {
        SimpleEvaluationContext context = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{DataBindingPropertyAccessor.forReadOnlyAccess(), new MapAccessor()}).withRootObject(this.buildContentModel(event, instance)).build();
        return (String)this.message.getValue((EvaluationContext)context, String.class);
    }

    protected Map<String, Object> buildContentModel(InstanceEvent event, Instance instance) {
        String string;
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("name", instance.getRegistration().getName());
        content.put("id", instance.getId().getValue());
        if (event instanceof InstanceStatusChangedEvent) {
            InstanceStatusChangedEvent statusChangedEvent = (InstanceStatusChangedEvent)event;
            string = statusChangedEvent.getStatusInfo().getStatus();
        } else {
            string = "UNKNOWN";
        }
        content.put("status", string);
        content.put("lastStatus", this.getLastStatus(event.getInstance()));
        return content;
    }

    protected abstract String getDefaultMessage();
}

