/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractContentNotifier;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class RocketChatNotifier
extends AbstractContentNotifier {
    private static final String DEFAULT_MESSAGE = "*#{name}* (#{id}) is *#{status}*";
    private RestTemplate restTemplate;
    @Nullable
    private String url;
    @Nullable
    private String roomId;
    @Nullable
    private String token;
    private String userId;

    public RocketChatNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("X-Auth-Token", this.token);
        headers.add("X-User-Id", this.userId);
        return Mono.fromRunnable(() -> this.restTemplate.exchange(this.getUri(), HttpMethod.POST, new HttpEntity(this.createMessage(event, instance), (MultiValueMap)headers), Void.class));
    }

    private URI getUri() {
        if (this.url == null) {
            throw new IllegalStateException("'url' must not be null.");
        }
        return URI.create(String.format("%s/api/v1/chat.sendMessage", this.url));
    }

    protected Object createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, String> messageJsonData = new HashMap<String, String>();
        messageJsonData.put("rid", this.roomId);
        messageJsonData.put("msg", this.createContent(event, instance));
        HashMap<String, HashMap<String, String>> messageJson = new HashMap<String, HashMap<String, String>>();
        messageJson.put("message", messageJsonData);
        return messageJson;
    }

    @Override
    protected Map<String, Object> buildContentModel(InstanceEvent event, Instance instance) {
        Map<String, Object> content = super.buildContentModel(event, instance);
        content.put("roomId", this.roomId);
        return content;
    }

    @Override
    protected String getDefaultMessage() {
        return DEFAULT_MESSAGE;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Nullable
    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

