/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.config;

import de.codecentric.boot.admin.server.config.SpringBootAdminServerEnabledCondition;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.CompositeNotifier;
import de.codecentric.boot.admin.server.notify.DingTalkNotifier;
import de.codecentric.boot.admin.server.notify.DiscordNotifier;
import de.codecentric.boot.admin.server.notify.FeiShuNotifier;
import de.codecentric.boot.admin.server.notify.HipchatNotifier;
import de.codecentric.boot.admin.server.notify.LetsChatNotifier;
import de.codecentric.boot.admin.server.notify.MailNotifier;
import de.codecentric.boot.admin.server.notify.MattermostNotifier;
import de.codecentric.boot.admin.server.notify.MicrosoftTeamsNotifier;
import de.codecentric.boot.admin.server.notify.NotificationTrigger;
import de.codecentric.boot.admin.server.notify.Notifier;
import de.codecentric.boot.admin.server.notify.NotifierProxyProperties;
import de.codecentric.boot.admin.server.notify.OpsGenieNotifier;
import de.codecentric.boot.admin.server.notify.PagerdutyNotifier;
import de.codecentric.boot.admin.server.notify.RocketChatNotifier;
import de.codecentric.boot.admin.server.notify.SlackNotifier;
import de.codecentric.boot.admin.server.notify.TelegramNotifier;
import de.codecentric.boot.admin.server.notify.WebexNotifier;
import de.codecentric.boot.admin.server.notify.filter.FilteringNotifier;
import de.codecentric.boot.admin.server.notify.filter.web.NotificationFilterController;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.HttpHost;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.web.client.RestTemplate;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration(proxyBeanMethods=false)
@Conditional(value={SpringBootAdminServerEnabledCondition.class})
@EnableConfigurationProperties(value={NotifierProxyProperties.class})
@AutoConfigureAfter(value={MailSenderAutoConfiguration.class})
public class AdminServerNotifierAutoConfiguration {
    private static RestTemplate createNotifierRestTemplate(NotifierProxyProperties proxyProperties) {
        RestTemplate restTemplate = new RestTemplate();
        if (proxyProperties.getHost() != null) {
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setProxy(new HttpHost(proxyProperties.getHost(), proxyProperties.getPort()));
            if (proxyProperties.getUsername() != null && proxyProperties.getPassword() != null) {
                AuthScope authScope = new AuthScope(proxyProperties.getHost(), proxyProperties.getPort());
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(proxyProperties.getUsername(), proxyProperties.getPassword().toCharArray());
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)builder.build()));
        }
        return restTemplate;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.webex", name={"auth-token"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class WebexNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.webex")
        public WebexNotifier webexNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new WebexNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.feishu", name={"webhook-url"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class FeiShuNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.feishu")
        public FeiShuNotifier feiShuNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new FeiShuNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.rocketchat", name={"url"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class RocketChatNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.rocketchat")
        public RocketChatNotifier rocketChatNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new RocketChatNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.dingtalk", name={"webhook-url"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class DingTalkNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.dingtalk")
        public DingTalkNotifier dingTalkNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new DingTalkNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.discord", name={"webhook-url"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class DiscordNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.discord")
        public DiscordNotifier discordNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new DiscordNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.telegram", name={"auth-token"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class TelegramNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.telegram")
        public TelegramNotifier telegramNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new TelegramNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.ms-teams", name={"webhook-url"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class MicrosoftTeamsNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.ms-teams")
        public MicrosoftTeamsNotifier microsoftTeamsNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new MicrosoftTeamsNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.opsgenie", name={"api-key"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class OpsGenieNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.opsgenie")
        public OpsGenieNotifier opsgenieNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new OpsGenieNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.pagerduty", name={"service-key"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class PagerdutyNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.pagerduty")
        public PagerdutyNotifier pagerdutyNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new PagerdutyNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.letschat", name={"url"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class LetsChatNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.letschat")
        public LetsChatNotifier letsChatNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new LetsChatNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.mattermost", name={"api-url"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class MattermostNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.mattermost")
        public MattermostNotifier mattermostNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new MattermostNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.slack", name={"webhook-url"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class SlackNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.slack")
        public SlackNotifier slackNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new SlackNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.hipchat", name={"url"})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @Lazy(value=false)
    public static class HipchatNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.hipchat")
        public HipchatNotifier hipchatNotifier(InstanceRepository repository, NotifierProxyProperties proxyProperties) {
            return new HipchatNotifier(repository, AdminServerNotifierAutoConfiguration.createNotifierRestTemplate(proxyProperties));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class, CompositeNotifierConfiguration.class})
    @ConditionalOnBean(value={MailSender.class})
    @Lazy(value=false)
    public static class MailNotifierConfiguration {
        private final ApplicationContext applicationContext;

        public MailNotifierConfiguration(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="spring.boot.admin.notify.mail")
        public MailNotifier mailNotifier(JavaMailSender mailSender, InstanceRepository repository, TemplateEngine mailNotifierTemplateEngine) {
            return new MailNotifier(mailSender, repository, mailNotifierTemplateEngine);
        }

        @Bean
        public TemplateEngine mailNotifierTemplateEngine() {
            ClassLoaderTemplateResolver resolver = new ClassLoaderTemplateResolver();
            resolver.setTemplateMode(TemplateMode.HTML);
            resolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
            SpringTemplateEngine templateEngine = new SpringTemplateEngine();
            templateEngine.setTemplateResolver((ITemplateResolver)resolver);
            return templateEngine;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleCandidate(value=FilteringNotifier.class)
    @Lazy(value=false)
    public static class FilteringNotifierWebConfiguration {
        private final FilteringNotifier filteringNotifier;

        public FilteringNotifierWebConfiguration(FilteringNotifier filteringNotifier) {
            this.filteringNotifier = filteringNotifier;
        }

        @Bean
        public NotificationFilterController notificationFilterController() {
            return new NotificationFilterController(this.filteringNotifier);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Notifier.class})
    @AutoConfigureBefore(value={NotifierTriggerConfiguration.class})
    @Lazy(value=false)
    public static class CompositeNotifierConfiguration {
        @Bean
        @Primary
        @Conditional(value={NoSingleNotifierCandidateCondition.class})
        public CompositeNotifier compositeNotifier(List<Notifier> notifiers) {
            return new CompositeNotifier(notifiers);
        }

        static class NoSingleNotifierCandidateCondition
        extends NoneNestedConditions {
            NoSingleNotifierCandidateCondition() {
                super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
            }

            @ConditionalOnSingleCandidate(value=Notifier.class)
            static class HasSingleNotifierInstance {
                HasSingleNotifierInstance() {
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Notifier.class})
    @Lazy(value=false)
    public static class NotifierTriggerConfiguration {
        @Bean(initMethod="start", destroyMethod="stop")
        @ConditionalOnMissingBean(value={NotificationTrigger.class})
        public NotificationTrigger notificationTrigger(Notifier notifier, Publisher<InstanceEvent> events) {
            return new NotificationTrigger(notifier, events);
        }
    }
}

