/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client.cookies;

import de.codecentric.boot.admin.server.domain.events.InstanceDeregisteredEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.services.AbstractEventHandler;
import de.codecentric.boot.admin.server.web.client.cookies.PerInstanceCookieStore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CookieStoreCleanupTrigger
extends AbstractEventHandler<InstanceDeregisteredEvent> {
    private final PerInstanceCookieStore cookieStore;

    public CookieStoreCleanupTrigger(Publisher<InstanceEvent> publisher, PerInstanceCookieStore cookieStore) {
        super(publisher, InstanceDeregisteredEvent.class);
        this.cookieStore = cookieStore;
    }

    @Override
    protected Publisher<Void> handle(Flux<InstanceDeregisteredEvent> publisher) {
        return publisher.flatMap(event -> {
            this.cleanupCookieStore((InstanceDeregisteredEvent)event);
            return Mono.empty();
        });
    }

    private void cleanupCookieStore(InstanceDeregisteredEvent event) {
        this.cookieStore.cleanupInstance(event.getInstance());
    }
}

