/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import de.codecentric.boot.admin.server.web.client.exception.ResolveEndpointException;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InstanceWebProxy {
    private static final Logger log = LoggerFactory.getLogger(InstanceWebProxy.class);
    private static final Instance NULL_INSTANCE = Instance.create(InstanceId.of("null"));
    private final InstanceWebClient instanceWebClient;
    private final ExchangeStrategies strategies = ExchangeStrategies.withDefaults();

    public InstanceWebProxy(InstanceWebClient instanceWebClient) {
        this.instanceWebClient = instanceWebClient;
    }

    public <V> Mono<V> forward(Mono<Instance> instanceMono, ForwardRequest forwardRequest, Function<ClientResponse, Mono<V>> responseHandler) {
        return instanceMono.defaultIfEmpty((Object)NULL_INSTANCE).flatMap(instance -> {
            if (!instance.equals(NULL_INSTANCE)) {
                return this.forward((Instance)instance, forwardRequest, responseHandler);
            }
            return Mono.defer(() -> (Mono)responseHandler.apply(ClientResponse.create((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE, (ExchangeStrategies)this.strategies).build()));
        });
    }

    public Flux<InstanceResponse> forward(Flux<Instance> instances, ForwardRequest forwardRequest) {
        return instances.flatMap(instance -> this.forward((Instance)instance, forwardRequest, (ClientResponse clientResponse) -> {
            InstanceResponse.Builder response = InstanceResponse.builder().instanceId(instance.getId()).status(clientResponse.rawStatusCode()).contentType(String.join((CharSequence)", ", clientResponse.headers().header("Content-Type")));
            return clientResponse.bodyToMono(String.class).map(response::body).defaultIfEmpty((Object)response).map(InstanceResponse.Builder::build);
        }));
    }

    private <V> Mono<V> forward(Instance instance, ForwardRequest forwardRequest, Function<ClientResponse, Mono<V>> responseHandler) {
        WebClient.RequestBodySpec bodySpec;
        log.trace("Proxy-Request for instance {} with URL '{}'", (Object)instance.getId(), (Object)forwardRequest.getUri());
        WebClient.RequestBodySpec headersSpec = bodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.instanceWebClient.instance(instance).method(forwardRequest.getMethod()).uri(forwardRequest.getUri())).headers(h -> h.addAll((MultiValueMap)forwardRequest.getHeaders()));
        if (this.requiresBody(forwardRequest.getMethod())) {
            headersSpec = bodySpec.body(forwardRequest.getBody());
        }
        return headersSpec.exchangeToMono(responseHandler).onErrorResume(ResolveEndpointException.class, ex -> {
            log.trace("No Endpoint found for Proxy-Request for instance {} with URL '{}'", (Object)instance.getId(), (Object)forwardRequest.getUri());
            return (Mono)responseHandler.apply(ClientResponse.create((HttpStatus)HttpStatus.NOT_FOUND, (ExchangeStrategies)this.strategies).build());
        }).onErrorResume(WebClientRequestException.class, ex -> {
            Throwable cause = ex.getCause();
            if (cause instanceof ReadTimeoutException || cause instanceof TimeoutException) {
                log.trace("Timeout for Proxy-Request for instance {} with URL '{}'", (Object)instance.getId(), (Object)forwardRequest.getUri());
                return (Mono)responseHandler.apply(ClientResponse.create((HttpStatus)HttpStatus.GATEWAY_TIMEOUT, (ExchangeStrategies)this.strategies).build());
            }
            if (cause instanceof IOException) {
                log.trace("Proxy-Request for instance {} with URL '{}' errored", new Object[]{instance.getId(), forwardRequest.getUri(), cause});
                return (Mono)responseHandler.apply(ClientResponse.create((HttpStatus)HttpStatus.BAD_GATEWAY, (ExchangeStrategies)this.strategies).build());
            }
            return Mono.error((Throwable)ex);
        });
    }

    private boolean requiresBody(HttpMethod method) {
        switch (method) {
            case PUT: 
            case POST: 
            case PATCH: {
                return true;
            }
        }
        return false;
    }

    public static class ForwardRequest {
        private final URI uri;
        private final HttpMethod method;
        private final HttpHeaders headers;
        private final BodyInserter<?, ? super ClientHttpRequest> body;

        ForwardRequest(URI uri, HttpMethod method, HttpHeaders headers, BodyInserter<?, ? super ClientHttpRequest> body) {
            this.uri = uri;
            this.method = method;
            this.headers = headers;
            this.body = body;
        }

        public static Builder builder() {
            return new Builder();
        }

        public URI getUri() {
            return this.uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public BodyInserter<?, ? super ClientHttpRequest> getBody() {
            return this.body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForwardRequest)) {
                return false;
            }
            ForwardRequest other = (ForwardRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
                return false;
            }
            HttpMethod this$method = this.getMethod();
            HttpMethod other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            HttpHeaders this$headers = this.getHeaders();
            HttpHeaders other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
                return false;
            }
            BodyInserter<?, ClientHttpRequest> this$body = this.getBody();
            BodyInserter<?, ? super ClientHttpRequest> other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForwardRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            HttpMethod $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            HttpHeaders $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
            BodyInserter<?, ClientHttpRequest> $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "InstanceWebProxy.ForwardRequest(uri=" + this.getUri() + ", method=" + this.getMethod() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ")";
        }

        public static class Builder {
            private URI uri;
            private HttpMethod method;
            private HttpHeaders headers;
            private BodyInserter<?, ? super ClientHttpRequest> body;

            Builder() {
            }

            public Builder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            public Builder method(HttpMethod method) {
                this.method = method;
                return this;
            }

            public Builder headers(HttpHeaders headers) {
                this.headers = headers;
                return this;
            }

            public Builder body(BodyInserter<?, ? super ClientHttpRequest> body) {
                this.body = body;
                return this;
            }

            public ForwardRequest build() {
                return new ForwardRequest(this.uri, this.method, this.headers, this.body);
            }

            public String toString() {
                return "InstanceWebProxy.ForwardRequest.Builder(uri=" + this.uri + ", method=" + this.method + ", headers=" + this.headers + ", body=" + this.body + ")";
            }
        }
    }

    public static class InstanceResponse {
        private final InstanceId instanceId;
        private final int status;
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private final String body;
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private final String contentType;

        InstanceResponse(InstanceId instanceId, int status, @Nullable String body, @Nullable String contentType) {
            this.instanceId = instanceId;
            this.status = status;
            this.body = body;
            this.contentType = contentType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public InstanceId getInstanceId() {
            return this.instanceId;
        }

        public int getStatus() {
            return this.status;
        }

        @Nullable
        public String getBody() {
            return this.body;
        }

        @Nullable
        public String getContentType() {
            return this.contentType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceResponse)) {
                return false;
            }
            InstanceResponse other = (InstanceResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            InstanceId this$instanceId = this.getInstanceId();
            InstanceId other$instanceId = other.getInstanceId();
            if (this$instanceId == null ? other$instanceId != null : !((Object)this$instanceId).equals(other$instanceId)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstanceResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatus();
            InstanceId $instanceId = this.getInstanceId();
            result = result * 59 + ($instanceId == null ? 43 : ((Object)$instanceId).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            return result;
        }

        public String toString() {
            return "InstanceWebProxy.InstanceResponse(instanceId=" + this.getInstanceId() + ", status=" + this.getStatus() + ", body=" + this.getBody() + ", contentType=" + this.getContentType() + ")";
        }

        public static class Builder {
            private InstanceId instanceId;
            private int status;
            private String body;
            private String contentType;

            Builder() {
            }

            public Builder instanceId(InstanceId instanceId) {
                this.instanceId = instanceId;
                return this;
            }

            public Builder status(int status) {
                this.status = status;
                return this;
            }

            public Builder body(@Nullable String body) {
                this.body = body;
                return this;
            }

            public Builder contentType(@Nullable String contentType) {
                this.contentType = contentType;
                return this;
            }

            public InstanceResponse build() {
                return new InstanceResponse(this.instanceId, this.status, this.body, this.contentType);
            }

            public String toString() {
                return "InstanceWebProxy.InstanceResponse.Builder(instanceId=" + this.instanceId + ", status=" + this.status + ", body=" + this.body + ", contentType=" + this.contentType + ")";
            }
        }
    }
}

