/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class HipchatNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_DESCRIPTION = "<strong>#{instance.registration.name}</strong>/#{instance.id} is <strong>#{event.statusInfo.status}</strong>";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate;
    @Nullable
    private URI url;
    @Nullable
    private String authToken;
    @Nullable
    private String roomId;
    private boolean notify = false;
    private Expression description;

    public HipchatNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
        this.description = this.parser.parseExpression(DEFAULT_DESCRIPTION, ParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.buildUrl(), this.createHipChatNotification(event, instance), Void.class, new Object[0]));
    }

    protected String buildUrl() {
        if (this.url == null) {
            throw new IllegalStateException("'url' must not be null.");
        }
        return String.format("%s/room/%s/notification?auth_token=%s", this.url.toString(), this.roomId, this.authToken);
    }

    protected HttpEntity<Map<String, Object>> createHipChatNotification(InstanceEvent event, Instance instance) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("color", this.getColor(event));
        body.put("message", this.getMessage(event, instance));
        body.put("notify", this.getNotify());
        body.put("message_format", "html");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    protected boolean getNotify() {
        return this.notify;
    }

    @Nullable
    protected String getMessage(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        StandardEvaluationContext context = new StandardEvaluationContext(root);
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        return (String)this.description.getValue((EvaluationContext)context, String.class);
    }

    protected String getColor(InstanceEvent event) {
        if (event instanceof InstanceStatusChangedEvent) {
            return "UP".equals(((InstanceStatusChangedEvent)event).getStatusInfo().getStatus()) ? "green" : "red";
        }
        return "gray";
    }

    public void setUrl(@Nullable URI url) {
        this.url = url;
    }

    @Nullable
    public URI getUrl() {
        return this.url;
    }

    public void setAuthToken(@Nullable String authToken) {
        this.authToken = authToken;
    }

    @Nullable
    public String getAuthToken() {
        return this.authToken;
    }

    public void setRoomId(@Nullable String roomId) {
        this.roomId = roomId;
    }

    @Nullable
    public String getRoomId() {
        return this.roomId;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setDescription(String description) {
        this.description = this.parser.parseExpression(description, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getDescription() {
        return this.description.getExpressionString();
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

