/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services.endpoints;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.Endpoint;
import de.codecentric.boot.admin.server.domain.values.Endpoints;
import de.codecentric.boot.admin.server.domain.values.Registration;
import de.codecentric.boot.admin.server.services.endpoints.EndpointDetectionStrategy;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public class QueryIndexEndpointStrategy
implements EndpointDetectionStrategy {
    private final InstanceWebClient instanceWebClient;
    private static final MediaType actuatorMediaType = MediaType.parseMediaType((String)"application/vnd.spring-boot.actuator.v2+json");

    public QueryIndexEndpointStrategy(InstanceWebClient instanceWebClient) {
        this.instanceWebClient = instanceWebClient;
    }

    @Override
    public Mono<Endpoints> detectEndpoints(Instance instance) {
        Registration registration = instance.getRegistration();
        String managementUrl = registration.getManagementUrl();
        if (managementUrl == null || Objects.equals(registration.getServiceUrl(), managementUrl)) {
            return Mono.empty();
        }
        return this.instanceWebClient.instance(instance).get().uri(managementUrl, new Object[0]).exchange().flatMap(response -> {
            if (response.statusCode().is2xxSuccessful()) {
                if (response.headers().contentType().map(arg_0 -> ((MediaType)actuatorMediaType).isCompatibleWith(arg_0)).orElse(false).booleanValue()) {
                    return response.bodyToMono(Response.class);
                }
            }
            return response.bodyToMono(Void.class).then(Mono.empty());
        }).flatMap(this::convert);
    }

    private Mono<Endpoints> convert(Response response) {
        List<Endpoint> endpoints = response.getLinks().entrySet().stream().filter(e -> !((String)e.getKey()).equals("self") && !((Response.EndpointRef)e.getValue()).isTemplated()).map(e -> Endpoint.of((String)e.getKey(), ((Response.EndpointRef)e.getValue()).getHref())).collect(Collectors.toList());
        if (endpoints.isEmpty()) {
            return Mono.empty();
        }
        return Mono.just((Object)Endpoints.of(endpoints));
    }

    static class Response {
        @JsonProperty(value="_links")
        private Map<String, EndpointRef> links = new HashMap<String, EndpointRef>();

        public Map<String, EndpointRef> getLinks() {
            return this.links;
        }

        public void setLinks(Map<String, EndpointRef> links) {
            this.links = links;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, EndpointRef> this$links = this.getLinks();
            Map<String, EndpointRef> other$links = other.getLinks();
            return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, EndpointRef> $links = this.getLinks();
            result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
            return result;
        }

        public String toString() {
            return "QueryIndexEndpointStrategy.Response(links=" + this.getLinks() + ")";
        }

        static class EndpointRef {
            private final String href;
            private final boolean templated;

            @JsonCreator
            EndpointRef(@JsonProperty(value="href") String href, @JsonProperty(value="templated") boolean templated) {
                this.href = href;
                this.templated = templated;
            }

            public String getHref() {
                return this.href;
            }

            public boolean isTemplated() {
                return this.templated;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EndpointRef)) {
                    return false;
                }
                EndpointRef other = (EndpointRef)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$href = this.getHref();
                String other$href = other.getHref();
                if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
                    return false;
                }
                return this.isTemplated() == other.isTemplated();
            }

            protected boolean canEqual(Object other) {
                return other instanceof EndpointRef;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $href = this.getHref();
                result = result * 59 + ($href == null ? 43 : $href.hashCode());
                result = result * 59 + (this.isTemplated() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "QueryIndexEndpointStrategy.Response.EndpointRef(href=" + this.getHref() + ", templated=" + this.isTemplated() + ")";
            }
        }
    }
}

