/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.values.Info;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class InfoUpdater {
    private static final Logger log = LoggerFactory.getLogger(InfoUpdater.class);
    private static final ParameterizedTypeReference<Map<String, Object>> RESPONSE_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final InstanceRepository repository;
    private final InstanceWebClient instanceWebClient;

    public InfoUpdater(InstanceRepository repository, InstanceWebClient instanceWebClient) {
        this.repository = repository;
        this.instanceWebClient = instanceWebClient;
    }

    public Mono<Void> updateInfo(InstanceId id) {
        return this.repository.computeIfPresent(id, (key, instance) -> this.doUpdateInfo((Instance)instance)).then();
    }

    protected Mono<Instance> doUpdateInfo(Instance instance) {
        if (instance.getStatusInfo().isOffline() || instance.getStatusInfo().isUnknown()) {
            return Mono.empty();
        }
        if (!instance.getEndpoints().isPresent("info")) {
            return Mono.empty();
        }
        log.debug("Update info for {}", (Object)instance);
        return this.instanceWebClient.instance(instance).get().uri("info", new Object[0]).exchange().log(log.getName(), Level.FINEST, new SignalType[0]).flatMap(response -> this.convertInfo(instance, (ClientResponse)response)).onErrorResume(ex -> Mono.just((Object)this.convertInfo(instance, (Throwable)ex))).map(instance::withInfo);
    }

    protected Mono<Info> convertInfo(Instance instance, ClientResponse response) {
        if (response.statusCode().is2xxSuccessful() && response.headers().contentType().map(mt -> mt.isCompatibleWith(MediaType.APPLICATION_JSON) || mt.isCompatibleWith(de.codecentric.boot.admin.server.utils.MediaType.ACTUATOR_V2_MEDIATYPE)).orElse(false).booleanValue()) {
            return response.bodyToMono(RESPONSE_TYPE).map(Info::from).defaultIfEmpty((Object)Info.empty());
        }
        log.info("Couldn't retrieve info for {}: {}", (Object)instance, (Object)response.statusCode());
        return response.bodyToMono(Void.class).then(Mono.just((Object)Info.empty()));
    }

    protected Info convertInfo(Instance instance, Throwable ex) {
        log.warn("Couldn't retrieve info for {}", (Object)instance, (Object)ex);
        return Info.empty();
    }
}

