/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.web.servlet.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class PreferMinifiedFilteringResourceResolver
extends AbstractResourceResolver {
    private final String extensionPrefix;

    public PreferMinifiedFilteringResourceResolver(String extensionPrefix) {
        this.extensionPrefix = extensionPrefix;
    }

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        ArrayList<Resource> newLocations = new ArrayList<Resource>(locations.size());
        for (Resource resource : locations) {
            Resource minified = this.findMinified(resource);
            newLocations.add(minified != null ? minified : resource);
        }
        return chain.resolveResource(request, requestPath, newLocations);
    }

    private Resource findMinified(Resource resource) {
        try {
            String basename = StringUtils.stripFilenameExtension((String)resource.getFilename());
            String extension = StringUtils.getFilenameExtension((String)resource.getFilename());
            Resource minified = resource.createRelative(basename + this.extensionPrefix + '.' + extension);
            if (minified.exists()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found minified file for '" + resource.getFilename() + "': '" + minified.getFilename() + "'"));
                }
                return minified;
            }
        }
        catch (IOException ex) {
            this.logger.trace((Object)("No minified resource for [" + resource.getFilename() + "]"), (Throwable)ex);
        }
        return null;
    }

    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations);
    }
}

