/*
 * Decompiled with CFR 0.152.
 */
package spring.boot.admin.turbine.config;

import de.codecentric.boot.admin.config.AdminServerProperties;
import de.codecentric.boot.admin.config.AdminServerWebConfiguration;
import de.codecentric.boot.admin.config.RevereseZuulProxyConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import spring.boot.admin.turbine.config.TurbineProperties;
import spring.boot.admin.turbine.web.TurbineController;
import spring.boot.admin.turbine.zuul.filters.TurbineRouteLocator;

@Configuration
@EnableConfigurationProperties(value={TurbineProperties.class})
@AutoConfigureBefore(value={AdminServerWebConfiguration.class, RevereseZuulProxyConfiguration.class})
@ConditionalOnProperty(value={"spring.boot.admin.turbine.enabled"}, matchIfMissing=true)
public class TurbineAutoConfiguration {
    @Autowired
    private TurbineProperties properties;
    @Autowired
    private ServerProperties server;
    @Autowired
    private ZuulProperties zuulProperties;

    @Bean
    public TurbineController TurbineController() {
        return new TurbineController(this.properties.getClusters());
    }

    @Bean
    @Order(value=100)
    public TurbineRouteLocator staticRouteLocator(AdminServerProperties admin, DiscoveryClient discovery) {
        ZuulProperties.ZuulRoute turbineRoute = new ZuulProperties.ZuulRoute(admin.getContextPath() + "/api/turbine/stream/**", this.properties.getLocation());
        return new TurbineRouteLocator(turbineRoute, this.server.getServletPrefix(), this.zuulProperties, discovery);
    }
}

