/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.registration.Application;
import de.codecentric.boot.admin.client.registration.RegistrationClient;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class BlockingRegistrationClient
implements RegistrationClient {
    private static final ParameterizedTypeReference<Map<String, Object>> RESPONSE_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final RestTemplate restTemplate;

    public BlockingRegistrationClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public String register(String adminUrl, Application application) {
        ResponseEntity response = this.restTemplate.exchange(adminUrl, HttpMethod.POST, new HttpEntity((Object)application, (MultiValueMap)this.createRequestHeaders()), RESPONSE_TYPE, new Object[0]);
        return ((Map)response.getBody()).get("id").toString();
    }

    @Override
    public void deregister(String adminUrl, String id) {
        this.restTemplate.delete(adminUrl + "/" + id, new Object[0]);
    }

    protected HttpHeaders createRequestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
    }
}

