/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.registration.Application;
import de.codecentric.boot.admin.client.registration.RegistrationClient;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestClient;

public class RestClientRegistrationClient
implements RegistrationClient {
    private static final ParameterizedTypeReference<Map<String, Object>> RESPONSE_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final RestClient restClient;

    public RestClientRegistrationClient(RestClient restClient) {
        this.restClient = restClient;
    }

    @Override
    public String register(String adminUrl, Application application) {
        Map response = (Map)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(adminUrl, new Object[0])).headers(this::setRequestHeaders)).body((Object)application).retrieve().body(RESPONSE_TYPE);
        return response.get("id").toString();
    }

    @Override
    public void deregister(String adminUrl, String id) {
        this.restClient.delete().uri(adminUrl + "/" + id, new Object[0]).retrieve().toBodilessEntity();
    }

    protected void setRequestHeaders(HttpHeaders headers) {
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
    }
}

