/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jbehave.junit.monitoring;

import de.codecentric.jbehave.junit.monitoring.DescriptionTextUniquefier;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepType;
import org.junit.runner.Description;

public class JUnitDescriptionGenerator {
    DescriptionTextUniquefier uniq = new DescriptionTextUniquefier();
    private int testCases;
    private List<StepCandidate> allCandidates = new ArrayList<StepCandidate>();
    private final Configuration configuration;
    private String previousNonAndStep;

    public JUnitDescriptionGenerator(List<CandidateSteps> candidateSteps, Configuration configuration) {
        this.configuration = configuration;
        for (CandidateSteps candidateStep : candidateSteps) {
            this.allCandidates.addAll(candidateStep.listCandidates());
        }
    }

    public Description createDescriptionFrom(Story story) {
        Description storyDescription = this.createDescriptionForStory(story);
        this.addAllScenariosToDescription(story, storyDescription);
        return storyDescription;
    }

    public Description createDescriptionFrom(Scenario scenario) {
        Description scenarioDescription = this.createDescriptionForScenario(scenario);
        if (this.hasGivenStories(scenario)) {
            this.insertGivenStories(scenario, scenarioDescription);
        }
        if (this.hasExamples(scenario)) {
            this.insertDescriptionForExamples(scenario, scenarioDescription);
        } else {
            this.addStepsToExample(scenario, scenarioDescription);
        }
        return scenarioDescription;
    }

    public String getJunitSafeString(String string) {
        return this.uniq.getUniqueDescription(this.replaceLinebreaks(string).replaceAll("[\\(\\)]", "|"));
    }

    public int getTestCases() {
        return this.testCases;
    }

    private boolean hasGivenStories(Scenario scenario) {
        return !scenario.getGivenStories().getPaths().isEmpty();
    }

    private boolean hasExamples(Scenario scenario) {
        return this.isParameterized(scenario) && !this.parameterNeededForGivenStories(scenario);
    }

    private boolean isParameterized(Scenario scenario) {
        ExamplesTable examplesTable = scenario.getExamplesTable();
        boolean isParameterized1 = examplesTable != null && examplesTable.getRowCount() > 0;
        return isParameterized1;
    }

    private boolean parameterNeededForGivenStories(Scenario scenario) {
        boolean parametersNeededForGivenStories = scenario.getGivenStories().requireParameters();
        return parametersNeededForGivenStories;
    }

    private void insertGivenStories(Scenario scenario, Description scenarioDescription) {
        for (String path : scenario.getGivenStories().getPaths()) {
            this.addGivenStoryToScenario(scenarioDescription, path);
        }
    }

    private void addGivenStoryToScenario(Description scenarioDescription, String path) {
        scenarioDescription.addChild(Description.createSuiteDescription((String)this.getJunitSafeString(this.getFilename(path)), (Annotation[])new Annotation[0]));
        ++this.testCases;
    }

    private String getFilename(String path) {
        return path.substring(path.lastIndexOf("/") + 1, path.length()).split("#")[0];
    }

    private void insertDescriptionForExamples(Scenario scenario, Description scenarioDescription) {
        ExamplesTable examplesTable = scenario.getExamplesTable();
        List rows = examplesTable.getRows();
        for (Map row : rows) {
            Description exampleRowDescription = Description.createSuiteDescription((String)(this.configuration.keywords().examplesTableRow() + " " + row), (Annotation[])null);
            scenarioDescription.addChild(exampleRowDescription);
            this.addStepsToExample(scenario, exampleRowDescription);
        }
    }

    private void addStepsToExample(Scenario scenario, Description description) {
        List steps = scenario.getSteps();
        this.addSteps(description, steps);
    }

    private void addSteps(Description description, List<String> steps) {
        this.previousNonAndStep = null;
        for (String stringStep : steps) {
            String stringStepOneLine = this.stripLinebreaks(stringStep);
            StepCandidate matchingStep = this.findMatchingStep(stringStep);
            if (matchingStep == null) {
                this.addNonExistingStep(description, stringStepOneLine, stringStep);
                continue;
            }
            this.addExistingStep(description, stringStepOneLine, matchingStep);
        }
    }

    private void addExistingStep(Description description, String stringStepOneLine, StepCandidate matchingStep) {
        if (matchingStep.isComposite()) {
            this.addCompositeSteps(description, stringStepOneLine, matchingStep);
        } else {
            this.addRegularStep(description, stringStepOneLine, matchingStep);
        }
    }

    private void addNonExistingStep(Description description, String stringStepOneLine, String stringStep) {
        try {
            StepType stepType = this.configuration.keywords().stepTypeFor(stringStep);
            if (stepType == StepType.IGNORABLE) {
                this.addIgnorableStep(description, stringStepOneLine);
            } else {
                this.addPendingStep(description, stringStepOneLine);
            }
        }
        catch (Keywords.StartingWordNotFound e) {
            // empty catch block
        }
    }

    private void addIgnorableStep(Description description, String stringStep) {
        ++this.testCases;
        Description ignorableDescription = Description.createSuiteDescription((String)stringStep, (Annotation[])new Annotation[0]);
        description.addChild(ignorableDescription);
    }

    private void addPendingStep(Description description, String stringStep) {
        ++this.testCases;
        Description testDescription = Description.createSuiteDescription((String)this.getJunitSafeString("[PENDING] " + stringStep), (Annotation[])new Annotation[0]);
        description.addChild(testDescription);
    }

    private void addRegularStep(Description description, String stringStep, StepCandidate step) {
        ++this.testCases;
        Description testDescription = Description.createTestDescription((Class)step.getStepsType(), (String)this.getJunitSafeString(stringStep));
        description.addChild(testDescription);
    }

    private void addCompositeSteps(Description description, String stringStep, StepCandidate step) {
        Description testDescription = Description.createSuiteDescription((String)this.getJunitSafeString(stringStep), (Annotation[])new Annotation[0]);
        this.addSteps(testDescription, Arrays.asList(step.composedSteps()));
        description.addChild(testDescription);
    }

    private void addAllScenariosToDescription(Story story, Description storyDescription) {
        List scenarios = story.getScenarios();
        for (Scenario scenario : scenarios) {
            storyDescription.addChild(this.createDescriptionFrom(scenario));
        }
    }

    private StepCandidate findMatchingStep(String stringStep) {
        for (StepCandidate step : this.allCandidates) {
            if (!step.matches(stringStep, this.previousNonAndStep)) continue;
            if (step.getStepType() != StepType.AND) {
                this.previousNonAndStep = step.getStartingWord() + " ";
            }
            return step;
        }
        return null;
    }

    private String stripLinebreaks(String stringStep) {
        if (stringStep.indexOf(10) != -1) {
            stringStep = stringStep.substring(0, stringStep.indexOf(10));
        }
        return stringStep;
    }

    private String replaceLinebreaks(String string) {
        return string.replaceAll("\r", "\n").replaceAll("\n{2,}", "\n").replaceAll("\n", ", ");
    }

    private Description createDescriptionForStory(Story story) {
        Description storyDescription = Description.createSuiteDescription((String)this.getJunitSafeString(story.getName()), (Annotation[])new Annotation[0]);
        return storyDescription;
    }

    private Description createDescriptionForScenario(Scenario scenario) {
        Description scenarioDescription = Description.createSuiteDescription((String)(this.configuration.keywords().scenario() + " " + this.getJunitSafeString(scenario.getTitle())), (Annotation[])new Annotation[0]);
        return scenarioDescription;
    }
}

