/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.xmlvalidation;

import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.exc.WstxUnexpectedCharException;
import de.codecentric.cxf.common.FaultType;
import de.codecentric.cxf.logging.BaseLogger;
import de.codecentric.cxf.xmlvalidation.SoapFaultBuilder;
import javax.xml.bind.UnmarshalException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;

public class XmlValidationInterceptor
extends AbstractSoapInterceptor {
    private static final BaseLogger LOG = BaseLogger.getLogger(XmlValidationInterceptor.class);
    private SoapFaultBuilder soapFaultBuilder;

    public XmlValidationInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(SoapMessage soapMessage) throws Fault {
        String faultMessage;
        Fault fault = (Fault)soapMessage.getContent(Exception.class);
        Throwable faultCause = fault.getCause();
        if (this.containsFaultIndicatingNotSchemeCompliantXml(faultCause, faultMessage = fault.getMessage())) {
            LOG.schemaValidationError(FaultType.SCHEME_VALIDATION_ERROR, faultMessage);
            this.soapFaultBuilder.buildCustomFaultAndSet2SoapMessage(soapMessage, FaultType.SCHEME_VALIDATION_ERROR);
        } else if (this.containsFaultIndicatingSyntacticallyIncorrectXml(faultCause)) {
            LOG.schemaValidationError(FaultType.SYNTACTICALLY_INCORRECT_XML_ERROR, faultMessage);
            this.soapFaultBuilder.buildCustomFaultAndSet2SoapMessage(soapMessage, FaultType.SYNTACTICALLY_INCORRECT_XML_ERROR);
        } else if (this.someOtherErrorOccured(faultCause)) {
            LOG.errorOccuredInBackendProcessing(faultCause);
            this.soapFaultBuilder.buildCustomFaultAndSet2SoapMessage(soapMessage, FaultType.BACKEND_PROCESSING_FAILED);
        }
    }

    private boolean containsFaultIndicatingNotSchemeCompliantXml(Throwable faultCause, String faultMessage) {
        return faultCause instanceof UnmarshalException || this.isNotNull(faultMessage) && faultMessage.contains("Unexpected wrapper element");
    }

    private boolean containsFaultIndicatingSyntacticallyIncorrectXml(Throwable faultCause) {
        return faultCause instanceof WstxException || this.isNotNull(faultCause) && faultCause.getCause() instanceof WstxUnexpectedCharException || faultCause instanceof IllegalArgumentException;
    }

    private boolean someOtherErrorOccured(Throwable faultCause) {
        return this.isNotNull(faultCause);
    }

    private boolean isNotNull(Object object) {
        return object != null;
    }

    public void setSoapFaultBuilder(SoapFaultBuilder soapFaultBuilder) {
        this.soapFaultBuilder = soapFaultBuilder;
    }
}

