/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.autodetection;

import de.codecentric.cxf.autodetection.InterfaceIncludingClassPathScanningCandidateComponentProvider;
import de.codecentric.cxf.common.BootStarterCxfException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class WebServiceScanner {
    protected static final String NO_CLASS_FOUND = "No class found";

    protected <T> Class scanForClassWhichImplementsAndPickFirst(Class<T> interfaceName, String packageName) throws BootStarterCxfException {
        ArrayList<String> namesOfClassesWithInterface = new ArrayList<String>();
        Set<BeanDefinition> beans = this.scanForClasses((TypeFilter)new AssignableTypeFilter(interfaceName), packageName);
        if (beans.isEmpty()) {
            throw new BootStarterCxfException(NO_CLASS_FOUND);
        }
        beans.forEach(beanDef -> namesOfClassesWithInterface.add(beanDef.getBeanClassName()));
        return this.justPickTheClassThatIsNotAnInterface(namesOfClassesWithInterface);
    }

    protected Class justPickTheClassThatIsNotAnInterface(List<String> namesOfClasses) throws BootStarterCxfException {
        for (String className : namesOfClasses) {
            if (this.isInterface(className)) continue;
            return this.classForName(className);
        }
        throw new BootStarterCxfException(NO_CLASS_FOUND);
    }

    private Set<BeanDefinition> scanForClasses(TypeFilter typeFilter, String basePackage) {
        InterfaceIncludingClassPathScanningCandidateComponentProvider scanningProvider = new InterfaceIncludingClassPathScanningCandidateComponentProvider();
        scanningProvider.addIncludeFilter(typeFilter);
        return scanningProvider.findCandidateComponents(basePackage);
    }

    protected <T extends Annotation> Class scanForClassWithAnnotationAndPickTheFirstOneFound(Class<T> annotationName, String packageName) throws BootStarterCxfException {
        return this.classForName(this.scanForClassNamesWithAnnotation(annotationName, packageName).get(0));
    }

    protected <T extends Annotation> List<String> scanForClassNamesWithAnnotation(Class<T> annotation, String packageName) throws BootStarterCxfException {
        ArrayList<String> namesOfClassesWithAnnotation = new ArrayList<String>();
        Set<BeanDefinition> beans = this.scanForClasses((TypeFilter)new AnnotationTypeFilter(annotation), packageName);
        if (beans.isEmpty()) {
            throw new BootStarterCxfException(NO_CLASS_FOUND);
        }
        beans.stream().forEach(bean -> namesOfClassesWithAnnotation.add(bean.getBeanClassName()));
        return namesOfClassesWithAnnotation;
    }

    protected <T extends Annotation> Class scanForClassWithAnnotationAndIsAnInterface(Class<T> annotationName, String packageName) throws BootStarterCxfException {
        List<String> namesOfClassesWithAnnotation = this.scanForClassNamesWithAnnotation(annotationName, packageName);
        if (namesOfClassesWithAnnotation.size() > 1) {
            return this.justPickTheClassThatIsAnInterface(namesOfClassesWithAnnotation);
        }
        return this.classForName(namesOfClassesWithAnnotation.get(0));
    }

    protected Class justPickTheClassThatIsAnInterface(List<String> namesOfClassesWithAnnotation) throws BootStarterCxfException {
        for (String className : namesOfClassesWithAnnotation) {
            if (!this.isInterface(className)) continue;
            return this.classForName(className);
        }
        throw new BootStarterCxfException(NO_CLASS_FOUND);
    }

    protected boolean isInterface(String className) throws BootStarterCxfException {
        return this.classForName(className).isInterface();
    }

    protected Class<?> classForName(String className) throws BootStarterCxfException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            throw new BootStarterCxfException(NO_CLASS_FOUND, exception);
        }
    }
}

