/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.advice;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.AbstractChaosMonkeyAdvice;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaosMonkeyDefaultAdvice
extends AbstractChaosMonkeyAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChaosMonkeyDefaultAdvice.class);
    private final ChaosMonkeyRequestScope chaosMonkeyRequestScope;
    private final MetricEventPublisher metricEventPublisher;
    private final ChaosTarget target;
    private final Predicate<ProceedingJoinPoint> isEnabled;

    public ChaosMonkeyDefaultAdvice(ChaosMonkeyRequestScope chaosMonkeyRequestScope, MetricEventPublisher metricEventPublisher, ChaosTarget target, BooleanSupplier isEnabled) {
        this(chaosMonkeyRequestScope, metricEventPublisher, target, (ProceedingJoinPoint pjp) -> isEnabled.getAsBoolean());
    }

    @Override
    public Object invoke(ProceedingJoinPoint pjp) throws Throwable {
        if (this.isEnabled.test(pjp)) {
            log.debug("Watching public method on {} class: {}", (Object)this.target.getName().toLowerCase(Locale.ROOT), (Object)pjp.getSignature());
            this.metricEventPublisher.publishMetricEvent(this.calculatePointcut(pjp.toShortString()), this.target.getMetricType(), new String[0]);
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            this.chaosMonkeyRequestScope.callChaosMonkey(this.target, this.createSignature(signature));
        }
        return pjp.proceed();
    }

    @Generated
    public ChaosMonkeyDefaultAdvice(ChaosMonkeyRequestScope chaosMonkeyRequestScope, MetricEventPublisher metricEventPublisher, ChaosTarget target, Predicate<ProceedingJoinPoint> isEnabled) {
        this.chaosMonkeyRequestScope = chaosMonkeyRequestScope;
        this.metricEventPublisher = metricEventPublisher;
        this.target = target;
        this.isEnabled = isEnabled;
    }
}

