/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.endpoints.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultException;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.validation.AssaultExceptionConstraint;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.validation.AssaultPropertiesUpdateLatencyRangeConstraint;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.springframework.validation.annotation.Validated;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.ObjectMapper;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@AssaultPropertiesUpdateLatencyRangeConstraint
public class AssaultPropertiesUpdate {
    @Min(value=1L)
    @Max(value=10000L)
    private @Nullable @Min(value=1L) @Max(value=10000L) Integer level;
    private @Nullable Boolean deterministic;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Nullable @Min(value=1L) @Max(value=0x7FFFFFFFL) Integer latencyRangeStart;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Nullable @Min(value=1L) @Max(value=0x7FFFFFFFL) Integer latencyRangeEnd;
    private @Nullable Boolean latencyActive;
    private @Nullable Boolean exceptionsActive;
    @AssaultExceptionConstraint
    private AssaultException exception;
    private @Nullable Boolean killApplicationActive;
    private @Nullable String killApplicationCronExpression;
    private volatile @Nullable Boolean memoryActive;
    @Min(value=1500L)
    @Max(value=0x7FFFFFFFL)
    private @Nullable @Min(value=1500L) @Max(value=0x7FFFFFFFL) Integer memoryMillisecondsHoldFilledMemory;
    @Min(value=100L)
    @Max(value=30000L)
    private @Nullable @Min(value=100L) @Max(value=30000L) Integer memoryMillisecondsWaitNextIncrease;
    @DecimalMax(value="1.0")
    @DecimalMin(value="0.0")
    private @Nullable @DecimalMax(value="1.0") @DecimalMin(value="0.0") Double memoryFillIncrementFraction;
    @DecimalMax(value="0.95")
    @DecimalMin(value="0.05")
    private @Nullable @DecimalMax(value="0.95") @DecimalMin(value="0.05") Double memoryFillTargetFraction;
    private @Nullable String memoryCronExpression;
    private @Nullable Boolean cpuActive;
    @Min(value=1500L)
    @Max(value=0x7FFFFFFFL)
    private @Nullable @Min(value=1500L) @Max(value=0x7FFFFFFFL) Integer cpuMillisecondsHoldLoad;
    @DecimalMax(value="1.0")
    @DecimalMin(value="0.1")
    private @Nullable @DecimalMax(value="1.0") @DecimalMin(value="0.1") Double cpuLoadTargetFraction;
    private @Nullable String cpuCronExpression;
    private @Nullable List<String> watchedCustomServices;

    public void applyTo(AssaultProperties t) {
        try {
            new ObjectMapper().updateValue((Object)t, (Object)this);
        }
        catch (DatabindException e) {
            throw new IllegalArgumentException("cannot update values", e);
        }
    }

    @Generated
    public @Nullable Integer getLevel() {
        return this.level;
    }

    @Generated
    public @Nullable Boolean getDeterministic() {
        return this.deterministic;
    }

    @Generated
    public @Nullable Integer getLatencyRangeStart() {
        return this.latencyRangeStart;
    }

    @Generated
    public @Nullable Integer getLatencyRangeEnd() {
        return this.latencyRangeEnd;
    }

    @Generated
    public @Nullable Boolean getLatencyActive() {
        return this.latencyActive;
    }

    @Generated
    public @Nullable Boolean getExceptionsActive() {
        return this.exceptionsActive;
    }

    @Generated
    public AssaultException getException() {
        return this.exception;
    }

    @Generated
    public @Nullable Boolean getKillApplicationActive() {
        return this.killApplicationActive;
    }

    @Generated
    public @Nullable String getKillApplicationCronExpression() {
        return this.killApplicationCronExpression;
    }

    @Generated
    public @Nullable Boolean getMemoryActive() {
        return this.memoryActive;
    }

    @Generated
    public @Nullable Integer getMemoryMillisecondsHoldFilledMemory() {
        return this.memoryMillisecondsHoldFilledMemory;
    }

    @Generated
    public @Nullable Integer getMemoryMillisecondsWaitNextIncrease() {
        return this.memoryMillisecondsWaitNextIncrease;
    }

    @Generated
    public @Nullable Double getMemoryFillIncrementFraction() {
        return this.memoryFillIncrementFraction;
    }

    @Generated
    public @Nullable Double getMemoryFillTargetFraction() {
        return this.memoryFillTargetFraction;
    }

    @Generated
    public @Nullable String getMemoryCronExpression() {
        return this.memoryCronExpression;
    }

    @Generated
    public @Nullable Boolean getCpuActive() {
        return this.cpuActive;
    }

    @Generated
    public @Nullable Integer getCpuMillisecondsHoldLoad() {
        return this.cpuMillisecondsHoldLoad;
    }

    @Generated
    public @Nullable Double getCpuLoadTargetFraction() {
        return this.cpuLoadTargetFraction;
    }

    @Generated
    public @Nullable String getCpuCronExpression() {
        return this.cpuCronExpression;
    }

    @Generated
    public @Nullable List<String> getWatchedCustomServices() {
        return this.watchedCustomServices;
    }

    @Generated
    public void setLevel(@Nullable Integer level) {
        this.level = level;
    }

    @Generated
    public void setDeterministic(@Nullable Boolean deterministic) {
        this.deterministic = deterministic;
    }

    @Generated
    public void setLatencyRangeStart(@Nullable Integer latencyRangeStart) {
        this.latencyRangeStart = latencyRangeStart;
    }

    @Generated
    public void setLatencyRangeEnd(@Nullable Integer latencyRangeEnd) {
        this.latencyRangeEnd = latencyRangeEnd;
    }

    @Generated
    public void setLatencyActive(@Nullable Boolean latencyActive) {
        this.latencyActive = latencyActive;
    }

    @Generated
    public void setExceptionsActive(@Nullable Boolean exceptionsActive) {
        this.exceptionsActive = exceptionsActive;
    }

    @Generated
    public void setException(AssaultException exception) {
        this.exception = exception;
    }

    @Generated
    public void setKillApplicationActive(@Nullable Boolean killApplicationActive) {
        this.killApplicationActive = killApplicationActive;
    }

    @Generated
    public void setKillApplicationCronExpression(@Nullable String killApplicationCronExpression) {
        this.killApplicationCronExpression = killApplicationCronExpression;
    }

    @Generated
    public void setMemoryActive(@Nullable Boolean memoryActive) {
        this.memoryActive = memoryActive;
    }

    @Generated
    public void setMemoryMillisecondsHoldFilledMemory(@Nullable Integer memoryMillisecondsHoldFilledMemory) {
        this.memoryMillisecondsHoldFilledMemory = memoryMillisecondsHoldFilledMemory;
    }

    @Generated
    public void setMemoryMillisecondsWaitNextIncrease(@Nullable Integer memoryMillisecondsWaitNextIncrease) {
        this.memoryMillisecondsWaitNextIncrease = memoryMillisecondsWaitNextIncrease;
    }

    @Generated
    public void setMemoryFillIncrementFraction(@Nullable Double memoryFillIncrementFraction) {
        this.memoryFillIncrementFraction = memoryFillIncrementFraction;
    }

    @Generated
    public void setMemoryFillTargetFraction(@Nullable Double memoryFillTargetFraction) {
        this.memoryFillTargetFraction = memoryFillTargetFraction;
    }

    @Generated
    public void setMemoryCronExpression(@Nullable String memoryCronExpression) {
        this.memoryCronExpression = memoryCronExpression;
    }

    @Generated
    public void setCpuActive(@Nullable Boolean cpuActive) {
        this.cpuActive = cpuActive;
    }

    @Generated
    public void setCpuMillisecondsHoldLoad(@Nullable Integer cpuMillisecondsHoldLoad) {
        this.cpuMillisecondsHoldLoad = cpuMillisecondsHoldLoad;
    }

    @Generated
    public void setCpuLoadTargetFraction(@Nullable Double cpuLoadTargetFraction) {
        this.cpuLoadTargetFraction = cpuLoadTargetFraction;
    }

    @Generated
    public void setCpuCronExpression(@Nullable String cpuCronExpression) {
        this.cpuCronExpression = cpuCronExpression;
    }

    @Generated
    public void setWatchedCustomServices(@Nullable List<String> watchedCustomServices) {
        this.watchedCustomServices = watchedCustomServices;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultPropertiesUpdate)) {
            return false;
        }
        AssaultPropertiesUpdate other = (AssaultPropertiesUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        Boolean this$deterministic = this.getDeterministic();
        Boolean other$deterministic = other.getDeterministic();
        if (this$deterministic == null ? other$deterministic != null : !((Object)this$deterministic).equals(other$deterministic)) {
            return false;
        }
        Integer this$latencyRangeStart = this.getLatencyRangeStart();
        Integer other$latencyRangeStart = other.getLatencyRangeStart();
        if (this$latencyRangeStart == null ? other$latencyRangeStart != null : !((Object)this$latencyRangeStart).equals(other$latencyRangeStart)) {
            return false;
        }
        Integer this$latencyRangeEnd = this.getLatencyRangeEnd();
        Integer other$latencyRangeEnd = other.getLatencyRangeEnd();
        if (this$latencyRangeEnd == null ? other$latencyRangeEnd != null : !((Object)this$latencyRangeEnd).equals(other$latencyRangeEnd)) {
            return false;
        }
        Boolean this$latencyActive = this.getLatencyActive();
        Boolean other$latencyActive = other.getLatencyActive();
        if (this$latencyActive == null ? other$latencyActive != null : !((Object)this$latencyActive).equals(other$latencyActive)) {
            return false;
        }
        Boolean this$exceptionsActive = this.getExceptionsActive();
        Boolean other$exceptionsActive = other.getExceptionsActive();
        if (this$exceptionsActive == null ? other$exceptionsActive != null : !((Object)this$exceptionsActive).equals(other$exceptionsActive)) {
            return false;
        }
        Boolean this$killApplicationActive = this.getKillApplicationActive();
        Boolean other$killApplicationActive = other.getKillApplicationActive();
        if (this$killApplicationActive == null ? other$killApplicationActive != null : !((Object)this$killApplicationActive).equals(other$killApplicationActive)) {
            return false;
        }
        Boolean this$memoryActive = this.getMemoryActive();
        Boolean other$memoryActive = other.getMemoryActive();
        if (this$memoryActive == null ? other$memoryActive != null : !((Object)this$memoryActive).equals(other$memoryActive)) {
            return false;
        }
        Integer this$memoryMillisecondsHoldFilledMemory = this.getMemoryMillisecondsHoldFilledMemory();
        Integer other$memoryMillisecondsHoldFilledMemory = other.getMemoryMillisecondsHoldFilledMemory();
        if (this$memoryMillisecondsHoldFilledMemory == null ? other$memoryMillisecondsHoldFilledMemory != null : !((Object)this$memoryMillisecondsHoldFilledMemory).equals(other$memoryMillisecondsHoldFilledMemory)) {
            return false;
        }
        Integer this$memoryMillisecondsWaitNextIncrease = this.getMemoryMillisecondsWaitNextIncrease();
        Integer other$memoryMillisecondsWaitNextIncrease = other.getMemoryMillisecondsWaitNextIncrease();
        if (this$memoryMillisecondsWaitNextIncrease == null ? other$memoryMillisecondsWaitNextIncrease != null : !((Object)this$memoryMillisecondsWaitNextIncrease).equals(other$memoryMillisecondsWaitNextIncrease)) {
            return false;
        }
        Double this$memoryFillIncrementFraction = this.getMemoryFillIncrementFraction();
        Double other$memoryFillIncrementFraction = other.getMemoryFillIncrementFraction();
        if (this$memoryFillIncrementFraction == null ? other$memoryFillIncrementFraction != null : !((Object)this$memoryFillIncrementFraction).equals(other$memoryFillIncrementFraction)) {
            return false;
        }
        Double this$memoryFillTargetFraction = this.getMemoryFillTargetFraction();
        Double other$memoryFillTargetFraction = other.getMemoryFillTargetFraction();
        if (this$memoryFillTargetFraction == null ? other$memoryFillTargetFraction != null : !((Object)this$memoryFillTargetFraction).equals(other$memoryFillTargetFraction)) {
            return false;
        }
        Boolean this$cpuActive = this.getCpuActive();
        Boolean other$cpuActive = other.getCpuActive();
        if (this$cpuActive == null ? other$cpuActive != null : !((Object)this$cpuActive).equals(other$cpuActive)) {
            return false;
        }
        Integer this$cpuMillisecondsHoldLoad = this.getCpuMillisecondsHoldLoad();
        Integer other$cpuMillisecondsHoldLoad = other.getCpuMillisecondsHoldLoad();
        if (this$cpuMillisecondsHoldLoad == null ? other$cpuMillisecondsHoldLoad != null : !((Object)this$cpuMillisecondsHoldLoad).equals(other$cpuMillisecondsHoldLoad)) {
            return false;
        }
        Double this$cpuLoadTargetFraction = this.getCpuLoadTargetFraction();
        Double other$cpuLoadTargetFraction = other.getCpuLoadTargetFraction();
        if (this$cpuLoadTargetFraction == null ? other$cpuLoadTargetFraction != null : !((Object)this$cpuLoadTargetFraction).equals(other$cpuLoadTargetFraction)) {
            return false;
        }
        AssaultException this$exception = this.getException();
        AssaultException other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception)) {
            return false;
        }
        String this$killApplicationCronExpression = this.getKillApplicationCronExpression();
        String other$killApplicationCronExpression = other.getKillApplicationCronExpression();
        if (this$killApplicationCronExpression == null ? other$killApplicationCronExpression != null : !this$killApplicationCronExpression.equals(other$killApplicationCronExpression)) {
            return false;
        }
        String this$memoryCronExpression = this.getMemoryCronExpression();
        String other$memoryCronExpression = other.getMemoryCronExpression();
        if (this$memoryCronExpression == null ? other$memoryCronExpression != null : !this$memoryCronExpression.equals(other$memoryCronExpression)) {
            return false;
        }
        String this$cpuCronExpression = this.getCpuCronExpression();
        String other$cpuCronExpression = other.getCpuCronExpression();
        if (this$cpuCronExpression == null ? other$cpuCronExpression != null : !this$cpuCronExpression.equals(other$cpuCronExpression)) {
            return false;
        }
        List<String> this$watchedCustomServices = this.getWatchedCustomServices();
        List<String> other$watchedCustomServices = other.getWatchedCustomServices();
        return !(this$watchedCustomServices == null ? other$watchedCustomServices != null : !((Object)this$watchedCustomServices).equals(other$watchedCustomServices));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssaultPropertiesUpdate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        Boolean $deterministic = this.getDeterministic();
        result = result * 59 + ($deterministic == null ? 43 : ((Object)$deterministic).hashCode());
        Integer $latencyRangeStart = this.getLatencyRangeStart();
        result = result * 59 + ($latencyRangeStart == null ? 43 : ((Object)$latencyRangeStart).hashCode());
        Integer $latencyRangeEnd = this.getLatencyRangeEnd();
        result = result * 59 + ($latencyRangeEnd == null ? 43 : ((Object)$latencyRangeEnd).hashCode());
        Boolean $latencyActive = this.getLatencyActive();
        result = result * 59 + ($latencyActive == null ? 43 : ((Object)$latencyActive).hashCode());
        Boolean $exceptionsActive = this.getExceptionsActive();
        result = result * 59 + ($exceptionsActive == null ? 43 : ((Object)$exceptionsActive).hashCode());
        Boolean $killApplicationActive = this.getKillApplicationActive();
        result = result * 59 + ($killApplicationActive == null ? 43 : ((Object)$killApplicationActive).hashCode());
        Boolean $memoryActive = this.getMemoryActive();
        result = result * 59 + ($memoryActive == null ? 43 : ((Object)$memoryActive).hashCode());
        Integer $memoryMillisecondsHoldFilledMemory = this.getMemoryMillisecondsHoldFilledMemory();
        result = result * 59 + ($memoryMillisecondsHoldFilledMemory == null ? 43 : ((Object)$memoryMillisecondsHoldFilledMemory).hashCode());
        Integer $memoryMillisecondsWaitNextIncrease = this.getMemoryMillisecondsWaitNextIncrease();
        result = result * 59 + ($memoryMillisecondsWaitNextIncrease == null ? 43 : ((Object)$memoryMillisecondsWaitNextIncrease).hashCode());
        Double $memoryFillIncrementFraction = this.getMemoryFillIncrementFraction();
        result = result * 59 + ($memoryFillIncrementFraction == null ? 43 : ((Object)$memoryFillIncrementFraction).hashCode());
        Double $memoryFillTargetFraction = this.getMemoryFillTargetFraction();
        result = result * 59 + ($memoryFillTargetFraction == null ? 43 : ((Object)$memoryFillTargetFraction).hashCode());
        Boolean $cpuActive = this.getCpuActive();
        result = result * 59 + ($cpuActive == null ? 43 : ((Object)$cpuActive).hashCode());
        Integer $cpuMillisecondsHoldLoad = this.getCpuMillisecondsHoldLoad();
        result = result * 59 + ($cpuMillisecondsHoldLoad == null ? 43 : ((Object)$cpuMillisecondsHoldLoad).hashCode());
        Double $cpuLoadTargetFraction = this.getCpuLoadTargetFraction();
        result = result * 59 + ($cpuLoadTargetFraction == null ? 43 : ((Object)$cpuLoadTargetFraction).hashCode());
        AssaultException $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
        String $killApplicationCronExpression = this.getKillApplicationCronExpression();
        result = result * 59 + ($killApplicationCronExpression == null ? 43 : $killApplicationCronExpression.hashCode());
        String $memoryCronExpression = this.getMemoryCronExpression();
        result = result * 59 + ($memoryCronExpression == null ? 43 : $memoryCronExpression.hashCode());
        String $cpuCronExpression = this.getCpuCronExpression();
        result = result * 59 + ($cpuCronExpression == null ? 43 : $cpuCronExpression.hashCode());
        List<String> $watchedCustomServices = this.getWatchedCustomServices();
        result = result * 59 + ($watchedCustomServices == null ? 43 : ((Object)$watchedCustomServices).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssaultPropertiesUpdate(level=" + this.getLevel() + ", deterministic=" + this.getDeterministic() + ", latencyRangeStart=" + this.getLatencyRangeStart() + ", latencyRangeEnd=" + this.getLatencyRangeEnd() + ", latencyActive=" + this.getLatencyActive() + ", exceptionsActive=" + this.getExceptionsActive() + ", exception=" + String.valueOf(this.getException()) + ", killApplicationActive=" + this.getKillApplicationActive() + ", killApplicationCronExpression=" + this.getKillApplicationCronExpression() + ", memoryActive=" + this.getMemoryActive() + ", memoryMillisecondsHoldFilledMemory=" + this.getMemoryMillisecondsHoldFilledMemory() + ", memoryMillisecondsWaitNextIncrease=" + this.getMemoryMillisecondsWaitNextIncrease() + ", memoryFillIncrementFraction=" + this.getMemoryFillIncrementFraction() + ", memoryFillTargetFraction=" + this.getMemoryFillTargetFraction() + ", memoryCronExpression=" + this.getMemoryCronExpression() + ", cpuActive=" + this.getCpuActive() + ", cpuMillisecondsHoldLoad=" + this.getCpuMillisecondsHoldLoad() + ", cpuLoadTargetFraction=" + this.getCpuLoadTargetFraction() + ", cpuCronExpression=" + this.getCpuCronExpression() + ", watchedCustomServices=" + String.valueOf(this.getWatchedCustomServices()) + ")";
    }

    @Generated
    public AssaultPropertiesUpdate() {
    }
}

