/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.assaults;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.unit.DataSize;

public class MemoryAssault
implements ChaosMonkeyRuntimeAssault {
    private static final Logger Logger = LoggerFactory.getLogger(MemoryAssault.class);
    private static final AtomicLong stolenMemory = new AtomicLong(0L);
    private static final int QUARTER_GIGA_BYTE_IN_BYTES = (int)DataSize.ofMegabytes((long)256L).toBytes();
    private final Runtime runtime;
    private final AtomicBoolean inAttack = new AtomicBoolean(false);
    private final ChaosMonkeySettings settings;
    private final MetricEventPublisher metricEventPublisher;

    public MemoryAssault(Runtime runtime, ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher) {
        this.runtime = runtime;
        this.settings = settings;
        this.metricEventPublisher = metricEventPublisher;
    }

    @Override
    public boolean isActive() {
        return this.settings.getAssaultProperties().isMemoryActive();
    }

    @Override
    @Async
    public void attack() {
        Logger.info("Chaos Monkey - memory assault");
        this.metricEventPublisher.publishMetricEvent(MetricType.MEMORY_ASSAULT, new String[0]);
        if (this.inAttack.compareAndSet(false, true)) {
            try {
                Logger.debug("Detected java version: {}", (Object)System.getProperty("java.version"));
                this.eatFreeMemory();
            }
            finally {
                this.inAttack.set(false);
            }
        }
        Logger.info("Chaos Monkey - memory assault cleaned up");
    }

    private void eatFreeMemory() {
        Vector<byte[]> memoryVector = new Vector<byte[]>();
        long stolenMemoryTotal = 0L;
        while (this.isActive()) {
            long freeMemory = this.runtime.freeMemory();
            long usedMemory = this.runtime.totalMemory() - freeMemory;
            if (this.cannotAllocateMoreMemory()) {
                Logger.debug("Cannot allocate more memory");
                break;
            }
            Logger.debug("Used memory in bytes: {}", (Object)usedMemory);
            stolenMemoryTotal = this.stealMemory(memoryVector, stolenMemoryTotal, this.getBytesToSteal());
            this.waitUntil(this.settings.getAssaultProperties().getMemoryMillisecondsWaitNextIncrease());
        }
        if (this.isActive()) {
            Logger.info("Memory fill reached, now sleeping and holding memory");
            this.waitUntil(this.settings.getAssaultProperties().getMemoryMillisecondsHoldFilledMemory());
        }
        memoryVector.clear();
        this.runtime.gc();
        long stolenAfterComplete = stolenMemory.addAndGet(-stolenMemoryTotal);
        this.metricEventPublisher.publishMetricEvent(MetricType.MEMORY_ASSAULT_MEMORY_STOLEN, stolenAfterComplete);
    }

    private boolean cannotAllocateMoreMemory() {
        double limit = (double)this.runtime.maxMemory() * this.settings.getAssaultProperties().getMemoryFillTargetFraction();
        return (double)this.runtime.totalMemory() > Math.floor(limit);
    }

    private int getBytesToSteal() {
        int amount = (int)((double)this.runtime.freeMemory() * this.settings.getAssaultProperties().getMemoryFillIncrementFraction());
        return Math.min(QUARTER_GIGA_BYTE_IN_BYTES, amount);
    }

    private long stealMemory(Vector<byte[]> memoryVector, long stolenMemoryTotal, int bytesToSteal) {
        memoryVector.add(this.createDirtyMemorySlice(bytesToSteal));
        long newStolenTotal = stolenMemory.addAndGet(bytesToSteal);
        this.metricEventPublisher.publishMetricEvent(MetricType.MEMORY_ASSAULT_MEMORY_STOLEN, newStolenTotal);
        Logger.debug("Chaos Monkey - memory assault increase, free memory: {}", (Object)DataSize.ofBytes((long)this.runtime.freeMemory()).toMegabytes());
        return stolenMemoryTotal += (long)bytesToSteal;
    }

    private byte[] createDirtyMemorySlice(int size) {
        byte[] b = new byte[size];
        for (int idx = 0; idx < size; idx += 4096) {
            b[idx] = 19;
        }
        return b;
    }

    private void waitUntil(int ms) {
        long startNano;
        long now = startNano = System.nanoTime();
        while (startNano + TimeUnit.MILLISECONDS.toNanos(ms) > now && this.isActive()) {
            try {
                long elapsed = TimeUnit.NANOSECONDS.toMillis(startNano - now);
                Thread.sleep(Math.min(100L, (long)ms - elapsed));
                now = System.nanoTime();
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    @Override
    public String getCronExpression(AssaultProperties assaultProperties) {
        return assaultProperties.getMemoryCronExpression();
    }
}

