/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.component;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRequestAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.ChaosToggleNameMapper;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.ChaosToggles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ChaosMonkeyRequestScope {
    private final ChaosMonkeySettings chaosMonkeySettings;
    private final List<ChaosMonkeyRequestAssault> assaults;
    private final ChaosToggles chaosToggles;
    private final ChaosToggleNameMapper chaosToggleNameMapper;
    private final MetricEventPublisher metricEventPublisher;
    private final AtomicInteger assaultCounter;

    public ChaosMonkeyRequestScope(ChaosMonkeySettings chaosMonkeySettings, List<ChaosMonkeyRequestAssault> assaults, List<ChaosMonkeyAssault> legacyAssaults, MetricEventPublisher metricEventPublisher, ChaosToggles chaosToggles, ChaosToggleNameMapper chaosToggleNameMapper) {
        List<RequestAssaultAdapter> assaultAdapters = legacyAssaults.stream().filter(it -> !(it instanceof ChaosMonkeyRequestAssault) && !(it instanceof ChaosMonkeyRuntimeAssault)).map(RequestAssaultAdapter::new).toList();
        ArrayList<ChaosMonkeyRequestAssault> requestAssaults = new ArrayList<ChaosMonkeyRequestAssault>();
        requestAssaults.addAll(assaults);
        requestAssaults.addAll(assaultAdapters);
        this.chaosMonkeySettings = chaosMonkeySettings;
        this.assaults = requestAssaults;
        this.metricEventPublisher = metricEventPublisher;
        this.chaosToggles = chaosToggles;
        this.chaosToggleNameMapper = chaosToggleNameMapper;
        this.assaultCounter = new AtomicInteger(0);
    }

    public void callChaosMonkey(ChaosTarget type, String simpleName) {
        if (this.isEnabled(type, simpleName) && this.isTrouble()) {
            AssaultProperties assaultProps;
            if (this.metricEventPublisher != null) {
                this.metricEventPublisher.publishMetricEvent(MetricType.APPLICATION_REQ_COUNT, "type", "total");
            }
            if ((assaultProps = this.chaosMonkeySettings.getAssaultProperties()).isWatchedCustomServicesActive()) {
                if (assaultProps.getWatchedCustomServices().stream().anyMatch(simpleName::startsWith)) {
                    this.chooseAndRunAttack();
                }
            } else {
                this.chooseAndRunAttack();
            }
        }
    }

    private void chooseAndRunAttack() {
        List<ChaosMonkeyAssault> activeAssaults = this.assaults.stream().filter(ChaosMonkeyAssault::isActive).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activeAssaults)) {
            return;
        }
        this.getRandomFrom(activeAssaults).attack();
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.publishMetricEvent(MetricType.APPLICATION_REQ_COUNT, "type", "assaulted");
        }
    }

    private ChaosMonkeyAssault getRandomFrom(List<ChaosMonkeyAssault> activeAssaults) {
        int exceptionRand = this.chaosMonkeySettings.getAssaultProperties().chooseAssault(activeAssaults.size());
        return activeAssaults.get(exceptionRand);
    }

    private boolean isTrouble() {
        if (this.chaosMonkeySettings.getAssaultProperties().isDeterministic()) {
            return this.assaultCounter.incrementAndGet() % this.chaosMonkeySettings.getAssaultProperties().getLevel() == 0;
        }
        return this.chaosMonkeySettings.getAssaultProperties().getTroubleRandom() >= this.chaosMonkeySettings.getAssaultProperties().getLevel();
    }

    private boolean isEnabled(ChaosTarget type, String name) {
        return this.chaosMonkeySettings.getChaosMonkeyProperties().isEnabled() && this.chaosToggles.isEnabled(this.chaosToggleNameMapper.mapName(type, name));
    }

    private record RequestAssaultAdapter(ChaosMonkeyAssault rawAssault) implements ChaosMonkeyRequestAssault
    {
        private static final Logger Logger = LoggerFactory.getLogger(RequestAssaultAdapter.class);

        private RequestAssaultAdapter {
            Logger.warn("Adapting a {} into a request assault. The class should extend its proper parent", (Object)rawAssault.getClass().getSimpleName());
        }

        @Override
        public boolean isActive() {
            return this.rawAssault.isActive();
        }

        @Override
        public void attack() {
            this.rawAssault.attack();
        }
    }
}

