/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.advice.filter;

import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import java.lang.reflect.Modifier;
import org.springframework.aop.ClassFilter;
import org.springframework.web.filter.GenericFilterBean;

public class ChaosMonkeyBaseClassFilter
implements ClassFilter {
    private final WatcherProperties watcherProperties;

    public boolean matches(Class<?> clazz) {
        return this.watcherProperties.getExcludeClasses().stream().noneMatch(exclude -> exclude.isAssignableFrom(clazz)) && !this.inChaosMonkeyPackage(clazz) && !this.inSpringCloudContextPackage(clazz) && this.nonFinalOrJdkProxiedClass(clazz) && !this.hasProblematicFinalMethod(clazz);
    }

    private boolean inChaosMonkeyPackage(Class<?> clazz) {
        return clazz.getName().startsWith("de.codecentric.spring.boot.chaos.monkey.");
    }

    private boolean inSpringCloudContextPackage(Class<?> clazz) {
        return clazz.getName().startsWith("org.springframework.cloud.context.");
    }

    private boolean nonFinalOrJdkProxiedClass(Class<?> clazz) {
        return !Modifier.isFinal(clazz.getModifiers()) || clazz.getName().startsWith("com.sun.proxy.");
    }

    private boolean hasProblematicFinalMethod(Class<?> clazz) {
        try {
            return GenericFilterBean.class.isAssignableFrom(clazz);
        }
        catch (NoClassDefFoundError error) {
            return false;
        }
    }

    public ChaosMonkeyBaseClassFilter(WatcherProperties watcherProperties) {
        this.watcherProperties = watcherProperties;
    }
}

