/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.aspect;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.ChaosMonkeyBaseAspect;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class SpringRepositoryAspectJPA
extends ChaosMonkeyBaseAspect {
    private static final Logger log = LoggerFactory.getLogger(SpringRepositoryAspectJPA.class);
    private final ChaosMonkeyRequestScope chaosMonkeyRequestScope;
    private MetricEventPublisher metricEventPublisher;
    private WatcherProperties watcherProperties;

    @Pointcut(value="this(org.springframework.data.repository.Repository) || within(@org.springframework.data.repository.RepositoryDefinition *)")
    public void implementsCrudRepository() {
    }

    @Around(value="implementsCrudRepository() && allPublicMethodPointcut() && !classInChaosMonkeyPackage()")
    public Object intercept(ProceedingJoinPoint pjp) throws Throwable {
        if (this.watcherProperties.isRepository()) {
            log.debug("Watching public method on repository class: {}", (Object)pjp.getSignature());
            if (this.metricEventPublisher != null) {
                this.metricEventPublisher.publishMetricEvent(this.calculatePointcut(pjp.toShortString()), MetricType.REPOSITORY, new String[0]);
            }
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            this.chaosMonkeyRequestScope.callChaosMonkey(ChaosTarget.REPOSITORY, this.createSignature(signature));
        }
        return pjp.proceed();
    }

    public SpringRepositoryAspectJPA(ChaosMonkeyRequestScope chaosMonkeyRequestScope, MetricEventPublisher metricEventPublisher, WatcherProperties watcherProperties) {
        this.chaosMonkeyRequestScope = chaosMonkeyRequestScope;
        this.metricEventPublisher = metricEventPublisher;
        this.watcherProperties = watcherProperties;
    }
}

