/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.endpoints.dto.validation;

import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultException;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.validation.AssaultExceptionConstraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssaultExceptionValidator
implements ConstraintValidator<AssaultExceptionConstraint, AssaultException> {
    private static final Logger Logger = LoggerFactory.getLogger(AssaultExceptionValidator.class);

    public boolean isValid(AssaultException exception, ConstraintValidatorContext constraintValidatorContext) {
        if (exception == null) {
            return true;
        }
        try {
            Class<? extends Throwable> exceptionClass = exception.getExceptionClass();
            if (exception.getArguments() == null) {
                exceptionClass.getConstructor(new Class[0]);
            } else {
                exceptionClass.getConstructor(exception.getExceptionArgumentTypes().toArray(new Class[0]));
            }
            return true;
        }
        catch (ReflectiveOperationException e) {
            Logger.warn("Invalid combination of type ({}) and arguments provided", (Object)exception.getType());
            return false;
        }
    }
}

