/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRequestAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ExceptionAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.KillAppAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.LatencyAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.MemoryAssault;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRuntimeScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyScheduler;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.Metrics;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyRestTemplateConfiguration;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyWebClientConfiguration;
import de.codecentric.spring.boot.chaos.monkey.configuration.UnleashChaosConfiguration;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.ChaosToggleNameMapper;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.ChaosToggles;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.DefaultChaosToggleNameMapper;
import de.codecentric.spring.boot.chaos.monkey.configuration.toggles.DefaultChaosToggles;
import de.codecentric.spring.boot.chaos.monkey.endpoints.ChaosMonkeyJmxEndpoint;
import de.codecentric.spring.boot.chaos.monkey.endpoints.ChaosMonkeyRestEndpoint;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.SpringBootHealthIndicatorAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.SpringComponentAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.SpringControllerAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.SpringRepositoryAspectJDBC;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.SpringRepositoryAspectJPA;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.SpringRestControllerAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.SpringServiceAspect;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.util.StreamUtils;

@Configuration
@Profile(value={"chaos-monkey"})
@EnableConfigurationProperties(value={ChaosMonkeyProperties.class, AssaultProperties.class, WatcherProperties.class})
@Import(value={UnleashChaosConfiguration.class, ChaosMonkeyWebClientConfiguration.class, ChaosMonkeyRestTemplateConfiguration.class})
@EnableScheduling
public class ChaosMonkeyConfiguration {
    private static final Logger Logger = LoggerFactory.getLogger(ChaosMonkeyConfiguration.class);
    private static final String CHAOS_MONKEY_TASK_SCHEDULER = "chaosMonkeyTaskScheduler";
    private final ChaosMonkeyProperties chaosMonkeyProperties;
    private final WatcherProperties watcherProperties;
    private final AssaultProperties assaultProperties;

    public ChaosMonkeyConfiguration(ChaosMonkeyProperties chaosMonkeyProperties, WatcherProperties watcherProperties, AssaultProperties assaultProperties) {
        this.chaosMonkeyProperties = chaosMonkeyProperties;
        this.watcherProperties = watcherProperties;
        this.assaultProperties = assaultProperties;
        try {
            String chaosLogo = StreamUtils.copyToString((InputStream)new ClassPathResource("chaos-logo.txt").getInputStream(), (Charset)Charset.defaultCharset());
            Logger.info(chaosLogo);
        }
        catch (IOException e) {
            Logger.info("Chaos Monkey - ready to do evil");
        }
    }

    @Bean
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    public Metrics metrics() {
        return new Metrics();
    }

    @Bean
    public MetricEventPublisher publisher() {
        return new MetricEventPublisher();
    }

    @Bean
    public ChaosMonkeySettings settings() {
        return new ChaosMonkeySettings(this.chaosMonkeyProperties, this.assaultProperties, this.watcherProperties);
    }

    @Bean
    public LatencyAssault latencyAssault() {
        return new LatencyAssault(this.settings(), this.publisher());
    }

    @Bean
    public ExceptionAssault exceptionAssault() {
        return new ExceptionAssault(this.settings(), this.publisher());
    }

    @Bean
    public KillAppAssault killAppAssault() {
        return new KillAppAssault(this.settings(), this.publisher());
    }

    @Bean
    public MemoryAssault memoryAssault() {
        return new MemoryAssault(Runtime.getRuntime(), this.settings(), this.publisher());
    }

    @Bean
    public ChaosMonkeyRequestScope chaosMonkeyRequestScope(List<ChaosMonkeyRequestAssault> chaosMonkeyAssaults, List<ChaosMonkeyAssault> allAssaults, ChaosToggles chaosToggles, ChaosToggleNameMapper chaosToggleNameMapper) {
        return new ChaosMonkeyRequestScope(this.settings(), chaosMonkeyAssaults, allAssaults, this.publisher(), chaosToggles, chaosToggleNameMapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={ChaosToggleNameMapper.class})
    public ChaosToggleNameMapper chaosToggleNameMapper(ChaosMonkeyProperties chaosMonkeyProperties) {
        return new DefaultChaosToggleNameMapper(chaosMonkeyProperties.getTogglePrefix());
    }

    @Bean
    @ConditionalOnMissingBean(value={ChaosToggles.class})
    public ChaosToggles chaosToggles() {
        return new DefaultChaosToggles();
    }

    @Bean
    public ChaosMonkeyScheduler scheduler(@Qualifier(value="chaosMonkeyTaskScheduler") TaskScheduler scheduler, ChaosMonkeyRuntimeScope runtimeScope) {
        ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
        registrar.setTaskScheduler(scheduler);
        return new ChaosMonkeyScheduler(registrar, this.assaultProperties, runtimeScope);
    }

    @Bean(name={"chaosMonkeyTaskScheduler"})
    public TaskScheduler chaosMonkeyTaskScheduler() {
        return new ThreadPoolTaskScheduler();
    }

    @Bean
    public ChaosMonkeyRuntimeScope chaosMonkeyRuntimeScope(List<ChaosMonkeyRuntimeAssault> chaosMonkeyAssaults) {
        return new ChaosMonkeyRuntimeScope(this.settings(), chaosMonkeyAssaults);
    }

    @Bean
    @DependsOn(value={"chaosMonkeyRequestScope"})
    public SpringControllerAspect controllerAspect(ChaosMonkeyRequestScope chaosMonkeyRequestScope) {
        return new SpringControllerAspect(chaosMonkeyRequestScope, this.publisher(), this.watcherProperties);
    }

    @Bean
    @DependsOn(value={"chaosMonkeyRequestScope"})
    public SpringRestControllerAspect restControllerAspect(ChaosMonkeyRequestScope chaosMonkeyRequestScope) {
        return new SpringRestControllerAspect(chaosMonkeyRequestScope, this.publisher(), this.watcherProperties);
    }

    @Bean
    @DependsOn(value={"chaosMonkeyRequestScope"})
    public SpringServiceAspect serviceAspect(ChaosMonkeyRequestScope chaosMonkeyRequestScope) {
        return new SpringServiceAspect(chaosMonkeyRequestScope, this.publisher(), this.watcherProperties);
    }

    @Bean
    @DependsOn(value={"chaosMonkeyRequestScope"})
    public SpringComponentAspect componentAspect(ChaosMonkeyRequestScope chaosMonkeyRequestScope) {
        return new SpringComponentAspect(chaosMonkeyRequestScope, this.publisher(), this.watcherProperties);
    }

    @Bean
    @DependsOn(value={"chaosMonkeyRequestScope"})
    @ConditionalOnClass(name={"org.springframework.data.repository.Repository"})
    public SpringRepositoryAspectJPA repositoryAspectJpa(ChaosMonkeyRequestScope chaosMonkeyRequestScope) {
        return new SpringRepositoryAspectJPA(chaosMonkeyRequestScope, this.publisher(), this.watcherProperties);
    }

    @Bean
    @DependsOn(value={"chaosMonkeyRequestScope"})
    public SpringRepositoryAspectJDBC repositoryAspectJdbc(ChaosMonkeyRequestScope chaosMonkeyRequestScope) {
        return new SpringRepositoryAspectJDBC(chaosMonkeyRequestScope, this.publisher(), this.watcherProperties);
    }

    @Bean
    @DependsOn(value={"chaosMonkeyRequestScope"})
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
    public SpringBootHealthIndicatorAspect springBootHealthIndicatorAspect(ChaosMonkeyRequestScope chaosMonkeyRequestScope) {
        return new SpringBootHealthIndicatorAspect(chaosMonkeyRequestScope);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public ChaosMonkeyRestEndpoint chaosMonkeyRestEndpoint(ChaosMonkeyRuntimeScope runtimeScope, ChaosMonkeyScheduler scheduler) {
        return new ChaosMonkeyRestEndpoint(this.settings(), runtimeScope, scheduler);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public ChaosMonkeyJmxEndpoint chaosMonkeyJmxEndpoint() {
        return new ChaosMonkeyJmxEndpoint(this.settings());
    }
}

