/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultException;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultExceptionConstraint;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultPropertiesLatencyRangeConstraint;
import de.codecentric.spring.boot.chaos.monkey.endpoints.AssaultPropertiesUpdate;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="chaos.monkey.assaults")
@Validated
@AssaultPropertiesLatencyRangeConstraint
public class AssaultProperties {
    @Value(value="${level : 1}")
    @Min(value=1L)
    @Max(value=10000L)
    private @Min(value=1L) @Max(value=10000L) int level;
    @Value(value="${latencyRangeStart : 1000}")
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) int latencyRangeStart;
    @Value(value="${latencyRangeEnd : 3000}")
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) int latencyRangeEnd;
    @Value(value="${latencyActive : false}")
    private boolean latencyActive;
    @Value(value="${exceptionsActive : false}")
    private boolean exceptionsActive;
    @AssaultExceptionConstraint
    private AssaultException exception;
    @Value(value="${killApplicationActive : false}")
    private boolean killApplicationActive;
    @Value(value="${memoryActive : false}")
    private volatile boolean memoryActive;
    @Value(value="${memoryMillisecondsHoldFilledMemory : 90000}")
    @Min(value=1500L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1500L) @Max(value=0x7FFFFFFFL) int memoryMillisecondsHoldFilledMemory;
    @Value(value="${memoryMillisecondsWaitNextIncrease : 1000}")
    @Min(value=100L)
    @Max(value=30000L)
    private @Min(value=100L) @Max(value=30000L) int memoryMillisecondsWaitNextIncrease;
    @Value(value="${memoryFillIncrementFraction : 0.15}")
    @DecimalMax(value="1.0")
    @DecimalMin(value="0.01")
    private @DecimalMax(value="1.0") @DecimalMin(value="0.01") double memoryFillIncrementFraction;
    @Value(value="${memoryFillTargetFraction : 0.25}")
    @DecimalMax(value="1.0")
    @DecimalMin(value="0.01")
    private @DecimalMax(value="1.0") @DecimalMin(value="0.01") double memoryFillTargetFraction;
    @Value(value="${runtime.scope.assault.cron.expression:OFF}")
    private String runtimeAssaultCronExpression;
    @Value(value="${watchedCustomServices:#{null}}")
    private List<String> watchedCustomServices;

    public AssaultException getException() {
        return this.exception == null ? new AssaultException() : this.exception;
    }

    public void setException(AssaultException exception) {
        this.exception = exception;
    }

    @JsonIgnore
    public int getTroubleRandom() {
        return ThreadLocalRandom.current().nextInt(1, this.getLevel() + 1);
    }

    @JsonIgnore
    public int chooseAssault(int amount) {
        return ThreadLocalRandom.current().nextInt(0, amount);
    }

    @JsonIgnore
    public boolean isWatchedCustomServicesActive() {
        return !CollectionUtils.isEmpty(this.watchedCustomServices);
    }

    public AssaultPropertiesUpdate toDto() {
        ObjectMapper mapper = new ObjectMapper();
        return (AssaultPropertiesUpdate)mapper.convertValue((Object)this, AssaultPropertiesUpdate.class);
    }

    public int getLevel() {
        return this.level;
    }

    public int getLatencyRangeStart() {
        return this.latencyRangeStart;
    }

    public int getLatencyRangeEnd() {
        return this.latencyRangeEnd;
    }

    public boolean isLatencyActive() {
        return this.latencyActive;
    }

    public boolean isExceptionsActive() {
        return this.exceptionsActive;
    }

    public boolean isKillApplicationActive() {
        return this.killApplicationActive;
    }

    public boolean isMemoryActive() {
        return this.memoryActive;
    }

    public int getMemoryMillisecondsHoldFilledMemory() {
        return this.memoryMillisecondsHoldFilledMemory;
    }

    public int getMemoryMillisecondsWaitNextIncrease() {
        return this.memoryMillisecondsWaitNextIncrease;
    }

    public double getMemoryFillIncrementFraction() {
        return this.memoryFillIncrementFraction;
    }

    public double getMemoryFillTargetFraction() {
        return this.memoryFillTargetFraction;
    }

    public String getRuntimeAssaultCronExpression() {
        return this.runtimeAssaultCronExpression;
    }

    public List<String> getWatchedCustomServices() {
        return this.watchedCustomServices;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLatencyRangeStart(int latencyRangeStart) {
        this.latencyRangeStart = latencyRangeStart;
    }

    public void setLatencyRangeEnd(int latencyRangeEnd) {
        this.latencyRangeEnd = latencyRangeEnd;
    }

    public void setLatencyActive(boolean latencyActive) {
        this.latencyActive = latencyActive;
    }

    public void setExceptionsActive(boolean exceptionsActive) {
        this.exceptionsActive = exceptionsActive;
    }

    public void setKillApplicationActive(boolean killApplicationActive) {
        this.killApplicationActive = killApplicationActive;
    }

    public void setMemoryActive(boolean memoryActive) {
        this.memoryActive = memoryActive;
    }

    public void setMemoryMillisecondsHoldFilledMemory(int memoryMillisecondsHoldFilledMemory) {
        this.memoryMillisecondsHoldFilledMemory = memoryMillisecondsHoldFilledMemory;
    }

    public void setMemoryMillisecondsWaitNextIncrease(int memoryMillisecondsWaitNextIncrease) {
        this.memoryMillisecondsWaitNextIncrease = memoryMillisecondsWaitNextIncrease;
    }

    public void setMemoryFillIncrementFraction(double memoryFillIncrementFraction) {
        this.memoryFillIncrementFraction = memoryFillIncrementFraction;
    }

    public void setMemoryFillTargetFraction(double memoryFillTargetFraction) {
        this.memoryFillTargetFraction = memoryFillTargetFraction;
    }

    public void setRuntimeAssaultCronExpression(String runtimeAssaultCronExpression) {
        this.runtimeAssaultCronExpression = runtimeAssaultCronExpression;
    }

    public void setWatchedCustomServices(List<String> watchedCustomServices) {
        this.watchedCustomServices = watchedCustomServices;
    }

    public String toString() {
        return "AssaultProperties(level=" + this.getLevel() + ", latencyRangeStart=" + this.getLatencyRangeStart() + ", latencyRangeEnd=" + this.getLatencyRangeEnd() + ", latencyActive=" + this.isLatencyActive() + ", exceptionsActive=" + this.isExceptionsActive() + ", exception=" + this.getException() + ", killApplicationActive=" + this.isKillApplicationActive() + ", memoryActive=" + this.isMemoryActive() + ", memoryMillisecondsHoldFilledMemory=" + this.getMemoryMillisecondsHoldFilledMemory() + ", memoryMillisecondsWaitNextIncrease=" + this.getMemoryMillisecondsWaitNextIncrease() + ", memoryFillIncrementFraction=" + this.getMemoryFillIncrementFraction() + ", memoryFillTargetFraction=" + this.getMemoryFillTargetFraction() + ", runtimeAssaultCronExpression=" + this.getRuntimeAssaultCronExpression() + ", watchedCustomServices=" + this.getWatchedCustomServices() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultProperties)) {
            return false;
        }
        AssaultProperties other = (AssaultProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getLatencyRangeStart() != other.getLatencyRangeStart()) {
            return false;
        }
        if (this.getLatencyRangeEnd() != other.getLatencyRangeEnd()) {
            return false;
        }
        if (this.isLatencyActive() != other.isLatencyActive()) {
            return false;
        }
        if (this.isExceptionsActive() != other.isExceptionsActive()) {
            return false;
        }
        if (this.isKillApplicationActive() != other.isKillApplicationActive()) {
            return false;
        }
        if (this.isMemoryActive() != other.isMemoryActive()) {
            return false;
        }
        if (this.getMemoryMillisecondsHoldFilledMemory() != other.getMemoryMillisecondsHoldFilledMemory()) {
            return false;
        }
        if (this.getMemoryMillisecondsWaitNextIncrease() != other.getMemoryMillisecondsWaitNextIncrease()) {
            return false;
        }
        if (Double.compare(this.getMemoryFillIncrementFraction(), other.getMemoryFillIncrementFraction()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryFillTargetFraction(), other.getMemoryFillTargetFraction()) != 0) {
            return false;
        }
        AssaultException this$exception = this.getException();
        AssaultException other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception)) {
            return false;
        }
        String this$runtimeAssaultCronExpression = this.getRuntimeAssaultCronExpression();
        String other$runtimeAssaultCronExpression = other.getRuntimeAssaultCronExpression();
        if (this$runtimeAssaultCronExpression == null ? other$runtimeAssaultCronExpression != null : !this$runtimeAssaultCronExpression.equals(other$runtimeAssaultCronExpression)) {
            return false;
        }
        List<String> this$watchedCustomServices = this.getWatchedCustomServices();
        List<String> other$watchedCustomServices = other.getWatchedCustomServices();
        return !(this$watchedCustomServices == null ? other$watchedCustomServices != null : !((Object)this$watchedCustomServices).equals(other$watchedCustomServices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssaultProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getLatencyRangeStart();
        result = result * 59 + this.getLatencyRangeEnd();
        result = result * 59 + (this.isLatencyActive() ? 79 : 97);
        result = result * 59 + (this.isExceptionsActive() ? 79 : 97);
        result = result * 59 + (this.isKillApplicationActive() ? 79 : 97);
        result = result * 59 + (this.isMemoryActive() ? 79 : 97);
        result = result * 59 + this.getMemoryMillisecondsHoldFilledMemory();
        result = result * 59 + this.getMemoryMillisecondsWaitNextIncrease();
        long $memoryFillIncrementFraction = Double.doubleToLongBits(this.getMemoryFillIncrementFraction());
        result = result * 59 + (int)($memoryFillIncrementFraction >>> 32 ^ $memoryFillIncrementFraction);
        long $memoryFillTargetFraction = Double.doubleToLongBits(this.getMemoryFillTargetFraction());
        result = result * 59 + (int)($memoryFillTargetFraction >>> 32 ^ $memoryFillTargetFraction);
        AssaultException $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
        String $runtimeAssaultCronExpression = this.getRuntimeAssaultCronExpression();
        result = result * 59 + ($runtimeAssaultCronExpression == null ? 43 : $runtimeAssaultCronExpression.hashCode());
        List<String> $watchedCustomServices = this.getWatchedCustomServices();
        result = result * 59 + ($watchedCustomServices == null ? 43 : ((Object)$watchedCustomServices).hashCode());
        return result;
    }
}

